/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0.model;

import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataStructure;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataType;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.Transition;
import org.openjdk.jmc.flightrecorder.internal.util.ParserToolkit;

public final class ValueDescriptor
implements Cloneable {
    private final String identifier;
    private final String name;
    private final String description;
    private final Transition transition;
    private final DataType dataType;
    private final String relationalKey;
    private final int contentType;
    private final DataStructure[] dataStructures;
    private final int structureIndex;

    public ValueDescriptor(String identifier, String name, String description, Transition transition, DataType dataType, String relationalKey, int contentType, DataStructure[] dataStructures, int structureIndex) {
        this.identifier = identifier;
        this.name = name;
        this.description = description;
        this.transition = transition;
        this.dataType = dataType;
        this.relationalKey = relationalKey;
        this.contentType = contentType;
        this.dataStructures = dataStructures;
        this.structureIndex = structureIndex;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getRelationalKey() {
        return this.relationalKey;
    }

    public int getContentType() {
        return this.contentType;
    }

    public DataType getInnerDataType() throws InvalidJfrFileException {
        ParserToolkit.assertValue((Object)this.dataType, (Object)DataType.ARRAY);
        return ParserToolkit.get(DataType.values(), this.structureIndex);
    }

    public ValueDescriptor[] getChildren() throws InvalidJfrFileException {
        ParserToolkit.assertValue((Object)this.dataType, new Object[]{DataType.STRUCT, DataType.STRUCTARRAY});
        return ParserToolkit.get(this.dataStructures, this.structureIndex).getValueDescriptors();
    }

    public String toString() {
        String toString = "";
        toString = toString + "Name: " + this.getName() + "\n";
        toString = toString + "Identifier: " + this.getIdentifier() + "\n";
        toString = toString + "Datatype: " + (Object)((Object)this.getDataType()) + "\n";
        toString = toString + "Description: " + this.getDescription() + "\n";
        toString = toString + "Transition : " + (Object)((Object)this.getTransition()) + "\n";
        toString = toString + "Relation Key: " + this.getRelationalKey() + "\n";
        return toString;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Can't happen");
        }
    }

    public static int getIndex(ValueDescriptor[] descriptors, String identifier) {
        for (int n = 0; n < descriptors.length; ++n) {
            if (!identifier.equals(descriptors[n].getIdentifier())) continue;
            return n;
        }
        return -1;
    }
}

