/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.AssignedMacro;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Paragraph;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.primitives.Else;
import com.dickimawbooks.texparserlib.primitives.Fi;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class If
extends Primitive
implements Expandable {
    protected TeXObjectList pending = null;

    public If() {
        this("if");
    }

    public If(String string) {
        super(string, true);
    }

    @Override
    public Object clone() {
        return new If(this.getName());
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        if (this.istrue(teXParser, teXObjectList)) {
            this.doTruePart(teXParser, teXObjectList, teXObjectList2);
        } else {
            this.doFalsePart(teXParser, teXObjectList, teXObjectList2);
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        if (this.istrue(teXParser, teXParser)) {
            this.doTruePart(teXParser, teXParser, teXObjectList);
        } else {
            this.doFalsePart(teXParser, teXParser, teXObjectList);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).expandfully(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.pending = null;
        if (this.istrue(teXParser, teXObjectList)) {
            this.doTruePart(teXParser, teXObjectList);
        } else {
            this.doFalsePart(teXParser, teXObjectList);
        }
        if (this.pending != null) {
            teXObjectList.push(this.pending, true);
            this.pending = null;
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.pending = null;
        if (this.istrue(teXParser, teXParser)) {
            this.doTruePart(teXParser, teXParser);
        } else {
            this.doFalsePart(teXParser, teXParser);
        }
        if (this.pending != null) {
            teXParser.push(this.pending, true);
            this.pending = null;
        }
    }

    public boolean istrue(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        byte by = TeXObjectList.POP_IGNORE_LEADING_SPACE;
        TeXObject teXObject = teXParser.popToken(by);
        TeXObject teXObject2 = teXParser.popToken(by);
        if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) == (teXObject2 = TeXParserUtils.resolve(teXObject2, teXParser))) {
            return true;
        }
        if (teXObject == null || teXObject2 == null) {
            return false;
        }
        return teXObject.equals(teXObject2);
    }

    protected void doTruePart(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.doTruePart(teXParser, teXObjectList, null);
    }

    protected void doTruePart(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        TeXObject teXObject = teXObjectList.expandedPopStack(teXParser);
        if (teXObject instanceof Else) {
            this.skipToFi(teXParser, teXObjectList);
        } else if (!(teXObject instanceof Fi)) {
            if (teXObjectList2 == null) {
                if (this.pending != null) {
                    this.pending.add(teXObject);
                } else if (teXObject instanceof Paragraph && ((Paragraph)teXObject).isIncomplete()) {
                    this.pending = teXParser.getListener().createStack();
                    this.pending.add(teXObject);
                } else if (teXParser == teXObjectList) {
                    teXObject.process(teXParser);
                } else {
                    teXObject.process(teXParser, teXObjectList);
                }
            } else {
                teXObjectList2.add(teXObject);
            }
            this.doTruePart(teXParser, teXObjectList, teXObjectList2);
        }
    }

    protected void skipToFi(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.resolve(teXObjectList.popToken(), teXParser);
        if (teXObject == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.expected", "\\fi");
        }
        if (!(teXObject instanceof Fi)) {
            this.skipToFi(teXParser, teXObjectList);
        }
    }

    protected boolean skipToElse(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = TeXParserUtils.resolve(teXObjectList.popToken(), teXParser);
        if (teXObject == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.expected", "\\fi");
        }
        if (teXObject instanceof Fi) {
            return false;
        }
        if (teXObject instanceof Else) {
            return true;
        }
        return this.skipToElse(teXParser, teXObjectList);
    }

    protected void doFalsePart(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.doFalsePart(teXParser, teXObjectList, null);
    }

    protected void doFalsePart(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        if (!this.skipToElse(teXParser, teXObjectList)) {
            return;
        }
        this.doRemainingFalsePart(teXParser, teXObjectList, teXObjectList2);
    }

    protected void doRemainingFalsePart(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        TeXObject teXObject = teXObjectList.expandedPopStack(teXParser);
        if (!(teXObject instanceof Fi)) {
            if (teXObjectList2 == null) {
                if (this.pending != null) {
                    this.pending.add(teXObject);
                } else if (teXObject instanceof Paragraph && ((Paragraph)teXObject).isIncomplete()) {
                    this.pending = teXParser.getListener().createStack();
                    this.pending.add(teXObject);
                } else if (teXParser == teXObjectList) {
                    teXObject.process(teXParser);
                } else {
                    teXObject.process(teXParser, teXObjectList);
                }
            } else {
                teXObjectList2.add(teXObject);
            }
            this.doRemainingFalsePart(teXParser, teXObjectList, teXObjectList2);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof TeXObject)) {
            return false;
        }
        if (object instanceof AssignedMacro) {
            return ((AssignedMacro)object).getUnderlying().equals(this);
        }
        return object.getClass().getName().equals(this.getClass().getName());
    }
}

