/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkRankImageFilter_h
#define sitkRankImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class RankImageFilter
\brief Rank filter of a greyscale image.

Nonlinear filter in which each output pixel is a user defined rank of input pixels in a user defined neighborhood. The default rank is 0.5 (median). The boundary conditions are different to the standard itkMedianImageFilter. In this filter the neighborhood is cropped at the boundary, and is therefore smaller.

This filter uses a recursive implementation - essentially the one by Huang 1979, I believe, to compute the rank, and is therefore usually a lot faster than the direct implementation. The extensions to Huang are support for arbitrary pixel types (using c++ maps) and arbitrary neighborhoods. I presume that these are not new ideas.

This filter is based on the sliding window code from the consolidatedMorphology package on InsightJournal.

The structuring element is assumed to be composed of binary values (zero or one). Only elements of the structuring element having values > 0 are candidates for affecting the center pixel.

This code was contributed in the Insight Journal paper: "Efficient implementation of kernel filtering" by Beare R., Lehmann G https://doi.org/10.54294/igq8fn 

\see MedianImageFilter 


\author Richard Beare
\sa itk::simple::Rank for the procedural interface
\sa itk::RankImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT RankImageFilter : public ImageFilter {
    public:
      using Self = RankImageFilter;

      /** Destructor */
      virtual ~RankImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      RankImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetRank ( double Rank ) { this->m_Rank = Rank; return *this; }

      /**
       */
      double GetRank() const { return this->m_Rank; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius ( std::vector<unsigned int> Radius ) { this->m_Radius = std::move(Radius); return *this; }

      /**
       */
      std::vector<unsigned int> GetRadius() const { return this->m_Radius; }\

      /**
       * Set the kernel or structuring element.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType ( KernelEnum KernelType ) { this->m_KernelType = KernelType; return *this; }

      /**
       * Get the kernel or structuring element .
       */
      KernelEnum GetKernelType() const { return this->m_KernelType; }

      /** Name of this class */
      std::string GetName() const { return std::string ("RankImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInternal on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      double  m_Rank{0.5};

      /*  */
      std::vector<unsigned int>  m_Radius{std::vector<unsigned int>(3, 1)};

      KernelEnum  m_KernelType{itk::simple::sitkBox};


    };

    /**\
     * \brief Rank filter of a greyscale image.
     *
     * This function directly calls the execute method of RankImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::RankImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image Rank ( const Image& image1, double rank = 0.5, std::vector<unsigned int> radius = std::vector<unsigned int>(3, 1), KernelEnum kernelType = itk::simple::sitkBox );

     /** @} */
}
#endif
