/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.library;

import com.google.common.base.Optional;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.protege.editor.owl.model.repository.MasterOntologyIDExtractor;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.entry.UriEntry;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.slf4j.LoggerFactory;

public class EditUriAction
extends AbstractAction {
    public static String UNKNOWN = "Unknown";
    public static String CALCULATING = "Calculating...";
    public static String NO_PARSE = "File didn't parse.";
    public static String NO_VERSION = "No version present";
    private JTree parent;
    private TreePath selectionPath;
    private File catalogFile;

    public EditUriAction(JTree parent, TreePath selectionPath, File catalogFile) {
        super("Edit Library Entry");
        this.parent = parent;
        this.selectionPath = selectionPath;
        this.catalogFile = catalogFile;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object catalog = null;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selectionPath.getLastPathComponent();
        Object container = ((DefaultMutableTreeNode)this.selectionPath.getPathComponent(this.selectionPath.getPathCount() - 2)).getUserObject();
        UriEntry entry = (UriEntry)node.getUserObject();
        EditPanel panel = new EditPanel(entry);
        JOptionPane pane = new JOptionPane(panel, 1, 2);
        JDialog dialog = pane.createDialog(this.parent, "Edit URI Redirect");
        dialog.setVisible(true);
        Object value = pane.getValue();
        if (value != null && value.equals(0)) {
            UriEntry editted = panel.getUriEntry();
            if (container instanceof XMLCatalog) {
                XMLCatalog lib = (XMLCatalog)container;
                lib.replaceEntry(entry, editted);
                node.setUserObject(editted);
                try {
                    CatalogUtilities.save(lib, this.catalogFile);
                }
                catch (IOException ex) {
                    LoggerFactory.getLogger(EditUriAction.class).error("An error occurred whilst saving the XML Catalog file: {}", (Throwable)ex);
                }
            }
        }
    }

    private class EditPanel
    extends JPanel {
        private UriEntry original;
        private JTextField importedUri;
        private JTextField physicalLocation;

        public EditPanel(UriEntry entry) {
            this.original = entry;
            this.setLayout(new GridLayout(0, 2));
            this.add(new JLabel("Imported Declaration: "));
            this.importedUri = new JTextField(entry.getName());
            this.add(this.importedUri);
            this.add(new JLabel());
            JButton updateImportedDeclaration = new JButton("Update Import Declaration Using Ontology Name");
            this.add(updateImportedDeclaration);
            updateImportedDeclaration.addActionListener(e -> {
                GetOntologyNamePanel panel = new GetOntologyNamePanel(this, this.importedUri, URI.create(this.physicalLocation.getText()));
                panel.pack();
                panel.setVisible(true);
            });
            this.add(new JLabel("Physical Location: "));
            this.physicalLocation = new JTextField(entry.getAbsoluteURI().toString());
            this.add(this.physicalLocation);
            this.add(new JLabel());
            JButton fileButton = new JButton("Browse");
            fileButton.addActionListener(new ChooseFileAction(this, this.original, this.physicalLocation));
            this.add(fileButton);
        }

        public UriEntry getUriEntry() {
            URI base = CatalogUtilities.resolveXmlBase(this.original);
            URI physicalUri = URI.create(this.physicalLocation.getText());
            physicalUri = base.relativize(physicalUri);
            return new UriEntry(this.original.getId(), this.original.getXmlBaseContext(), this.importedUri.getText(), physicalUri, this.original.getXmlBase());
        }
    }

    private class GetOntologyNamePanel
    extends JDialog {
        private JTextField ontologyNameField;
        private JTextField ontologyVersionField;
        private JButton useOntologyName;
        private JButton useOntologyVersion;

        public GetOntologyNamePanel(JComponent parent, JTextField importedUri, URI physicalLocation) {
            super(JOptionPane.getFrameForComponent(parent), "Update Import Declaration Using Ontology Name");
            this.getContentPane().setLayout(new BorderLayout());
            JPanel centerPanel = new JPanel(new GridLayout(0, 2));
            centerPanel.add(new JLabel("Ontology Name:"));
            this.ontologyNameField = new JTextField();
            centerPanel.add(this.ontologyNameField);
            centerPanel.add(new JLabel("Ontology Version: "));
            this.ontologyVersionField = new JTextField();
            centerPanel.add(this.ontologyVersionField);
            this.getContentPane().add((Component)centerPanel, "Center");
            JPanel southPanel = new JPanel(new FlowLayout());
            this.useOntologyName = new JButton("Use Ontology Name");
            southPanel.add(this.useOntologyName);
            this.useOntologyName.addActionListener(e -> {
                importedUri.setText(this.ontologyNameField.getText());
                this.setVisible(false);
            });
            this.useOntologyVersion = new JButton("Use Ontology Version");
            southPanel.add(this.useOntologyVersion);
            this.useOntologyVersion.addActionListener(e -> {
                importedUri.setText(this.ontologyVersionField.getText());
                this.setVisible(false);
            });
            JButton cancel = new JButton("Cancel");
            southPanel.add(cancel);
            cancel.addActionListener(e -> this.setVisible(false));
            this.getContentPane().add((Component)southPanel, "South");
            this.updateOntologyName(physicalLocation);
        }

        private void updateOntologyName(URI physicalLocation) {
            try {
                this.ontologyNameField.setText(CALCULATING);
                this.ontologyVersionField.setText(CALCULATING);
                MasterOntologyIDExtractor extractor = new MasterOntologyIDExtractor();
                Optional<OWLOntologyID> id = extractor.getOntologyId(physicalLocation);
                this.ontologyNameField.setText(((IRI)((OWLOntologyID)id.get()).getOntologyIRI().get()).toString());
                if (((OWLOntologyID)id.get()).getVersionIRI().isPresent()) {
                    this.ontologyVersionField.setText(((IRI)((OWLOntologyID)id.get()).getVersionIRI().get()).toQuotedString());
                } else {
                    this.ontologyVersionField.setText(NO_VERSION);
                }
            }
            catch (Throwable t) {
                this.ontologyNameField.setText(NO_PARSE);
                this.ontologyVersionField.setText(NO_PARSE);
            }
            this.updateUseOntologyNameButtonsEnabled();
        }

        private void updateUseOntologyNameButtonsEnabled() {
            this.useOntologyName.setEnabled(this.isValidOntologyNameOrVersion(this.ontologyNameField.getText()));
            this.useOntologyVersion.setEnabled(this.isValidOntologyNameOrVersion(this.ontologyVersionField.getText()));
        }

        private boolean isValidOntologyNameOrVersion(String name) {
            return name != null && !name.equals(UNKNOWN) && !name.equals(CALCULATING) && !name.equals(NO_PARSE) && !name.equals(NO_VERSION);
        }
    }

    private class ChooseFileAction
    extends AbstractAction {
        private JComponent parent;
        private UriEntry original;
        private JTextField physicalLocation;

        public ChooseFileAction(JComponent parent, UriEntry original, JTextField physicalLocation) {
            this.parent = parent;
            this.original = original;
            this.physicalLocation = physicalLocation;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int retValue;
            File directory;
            JFileChooser fileChooser = new JFileChooser();
            URI base = CatalogUtilities.resolveXmlBase(this.original);
            if (base != null && (directory = new File(base)).isDirectory()) {
                fileChooser.setCurrentDirectory(directory);
            }
            if ((retValue = fileChooser.showOpenDialog(this.parent)) == 0) {
                this.physicalLocation.setText(fileChooser.getSelectedFile().toURI().toString());
            }
        }
    }
}

