/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.key;

import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.key.DkKeyMaker;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.util.Des;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.util.Nfold;

public class Des3KeyMaker
extends DkKeyMaker {
    public Des3KeyMaker(EncryptProvider encProvider) {
        super(encProvider);
    }

    @Override
    public byte[] str2key(String string, String salt, byte[] param) throws KrbException {
        byte[] utf8Bytes = Des3KeyMaker.makePasswdSalt(string, salt);
        int keyInputSize = this.encProvider().keyInputSize();
        byte[] tmpKey = this.random2Key(Nfold.nfold(utf8Bytes, keyInputSize));
        return this.dk(tmpKey, KERBEROS_CONSTANT);
    }

    private static byte[] getEightBits(byte[] bits56) {
        byte[] bits64 = new byte[8];
        System.arraycopy(bits56, 0, bits64, 0, 7);
        bits64[7] = (byte)((bits56[0] & 1) << 1 | (bits56[1] & 1) << 2 | (bits56[2] & 1) << 3 | (bits56[3] & 1) << 4 | (bits56[4] & 1) << 5 | (bits56[5] & 1) << 6 | (bits56[6] & 1) << 7);
        return bits64;
    }

    @Override
    public byte[] random2Key(byte[] randomBits) throws KrbException {
        int i;
        if (randomBits.length != this.encProvider().keyInputSize()) {
            throw new KrbException("Invalid random bits, not of correct bytes size");
        }
        byte[] key = new byte[this.encProvider().keySize()];
        byte[] tmp1 = new byte[7];
        for (i = 0; i < 3; ++i) {
            System.arraycopy(randomBits, i * 7, key, i * 8, 7);
            System.arraycopy(randomBits, i * 7, tmp1, 0, 7);
            byte[] tmp2 = Des3KeyMaker.getEightBits(tmp1);
            key[8 * (i + 1) - 1] = tmp2[7];
            int nthByte = i * 8;
            key[nthByte + 7] = (byte)((key[nthByte + 0] & 1) << 1 | (key[nthByte + 1] & 1) << 2 | (key[nthByte + 2] & 1) << 3 | (key[nthByte + 3] & 1) << 4 | (key[nthByte + 4] & 1) << 5 | (key[nthByte + 5] & 1) << 6 | (key[nthByte + 6] & 1) << 7);
            for (int j = 0; j < 8; ++j) {
                int tmp = key[nthByte + j] & 0xFE;
                tmp |= Integer.bitCount(tmp) & 1 ^ 1;
                key[nthByte + j] = (byte)tmp;
            }
        }
        for (i = 0; i < 3; ++i) {
            Des.fixKey(key, i * 8, 8);
        }
        return key;
    }
}

