/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.diagnostics;

import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.clio.annotations.Sensitive;
import oracle.jdbc.diagnostics.SecurityLabel;

public interface Diagnosable {
    default public Object secure(@Sensitive Object value) {
        return this.getDiagnosable().secure(value);
    }

    @Sensitive(value=Sensitive.Dependency.DEPENDENT)
    default public Object format(Format.Style f, Object value, long ... args) {
        return this.getDiagnosable().format(f, value, args);
    }

    default public <T extends Throwable> T trace(Level level, SecurityLabel securityLabel, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        return this.getDiagnosable().trace(level, securityLabel, className, methodName, publicMessage, privateMessage, thrown, args);
    }

    default public <T extends Throwable> T debug(Level level, SecurityLabel securityLabel, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        return this.getDiagnosable().debug(level, securityLabel, className, methodName, publicMessage, privateMessage, thrown, args);
    }

    default public <T extends Throwable> T trace(Level level, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        return this.trace(level, SecurityLabel.INTERNAL, className, methodName, publicMessage, privateMessage, thrown, args);
    }

    default public <T extends Throwable> T debug(Level level, String className, String methodName, String publicMessage, String privateMessage, T thrown, Object ... args) {
        return this.debug(level, SecurityLabel.INTERNAL, className, methodName, publicMessage, privateMessage, thrown, args);
    }

    default public void suspendLogging() {
        this.getDiagnosable().suspendLogging();
    }

    default public void resumeLogging() {
        this.getDiagnosable().resumeLogging();
    }

    default public void beginCurrentSql(String sql) {
        this.getDiagnosable().beginCurrentSql(sql);
    }

    default public void endCurrentSql() {
        this.getDiagnosable().endCurrentSql();
    }

    default public boolean isLoggingLevelFinest() {
        return this.getDiagnosable().isLoggingLevelFinest();
    }

    default public Diagnosable getDiagnosable() {
        throw new NoSuchMethodError();
    }
}

