/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Random;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.trogdor.workload.FlushGenerator;

public class GaussianFlushGenerator
implements FlushGenerator {
    private final int messagesPerFlushAverage;
    private final double messagesPerFlushDeviation;
    private final Random random = new Random();
    private int messageTracker = 0;
    private int flushSize = 0;

    @JsonCreator
    public GaussianFlushGenerator(@JsonProperty(value="messagesPerFlushAverage") int messagesPerFlushAverage, @JsonProperty(value="messagesPerFlushDeviation") double messagesPerFlushDeviation) {
        this.messagesPerFlushAverage = messagesPerFlushAverage;
        this.messagesPerFlushDeviation = messagesPerFlushDeviation;
        this.calculateFlushSize();
    }

    @JsonProperty
    public int messagesPerFlushAverage() {
        return this.messagesPerFlushAverage;
    }

    @JsonProperty
    public double messagesPerFlushDeviation() {
        return this.messagesPerFlushDeviation;
    }

    private synchronized void calculateFlushSize() {
        this.flushSize = Math.max((int)(this.random.nextGaussian() * this.messagesPerFlushDeviation) + this.messagesPerFlushAverage, 1);
        this.messageTracker = 0;
    }

    @Override
    public synchronized <K, V> void increment(KafkaProducer<K, V> producer) {
        ++this.messageTracker;
        if (this.messageTracker >= this.flushSize) {
            try {
                producer.flush();
            }
            catch (InterruptException interruptException) {
                // empty catch block
            }
            this.calculateFlushSize();
        }
    }
}

