/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife.plaf.basic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import net.sf.juife.Dial;
import net.sf.juife.plaf.DialUI;

public class BasicDialUI
extends DialUI {
    private Dial dial;
    private TrackListener trackListener;
    private final Handler handler = new Handler();

    private BasicDialUI(Dial dial) {
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicDialUI((Dial)c);
    }

    @Override
    public void installUI(JComponent c) {
        this.dial = (Dial)c;
        this.trackListener = new TrackListener();
        this.installListeners(this.dial);
        this.installKeyboradActions(this.dial);
    }

    private void installListeners(Dial d) {
        d.addMouseListener(this.trackListener);
        d.addMouseMotionListener(this.trackListener);
        d.addChangeListener(this.getHandler());
    }

    private void installKeyboradActions(Dial d) {
        d.getInputMap(0).put(KeyStroke.getKeyStroke("LEFT"), "decrementDialValue");
        d.getActionMap().put("decrementDialValue", new Actions("decrementDialValue"));
        d.getInputMap(0).put(KeyStroke.getKeyStroke("DOWN"), "decrementDialValueX4");
        d.getActionMap().put("decrementDialValueX4", new Actions("decrementDialValueX4"));
        d.getInputMap(0).put(KeyStroke.getKeyStroke("RIGHT"), "incrementDialValue");
        d.getActionMap().put("incrementDialValue", new Actions("incrementDialValue"));
        d.getInputMap(0).put(KeyStroke.getKeyStroke("UP"), "incrementDialValueX4");
        d.getActionMap().put("incrementDialValueX4", new Actions("incrementDialValueX4"));
        d.getInputMap(0).put(KeyStroke.getKeyStroke("HOME"), "setMinimum");
        d.getActionMap().put("setMinimum", new Actions("setMinimum"));
        d.getInputMap(0).put(KeyStroke.getKeyStroke("END"), "setMaximum");
        d.getActionMap().put("setMaximum", new Actions("setMaximum"));
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners(this.dial);
        this.uninstallKeyboradActions(this.dial);
        this.trackListener = null;
    }

    private void uninstallListeners(Dial d) {
        d.removeMouseListener(this.trackListener);
        d.removeMouseMotionListener(this.trackListener);
        d.removeChangeListener(this.getHandler());
    }

    private void uninstallKeyboradActions(Dial d) {
        d.getInputMap(0).remove(KeyStroke.getKeyStroke("LEFT"));
        d.getActionMap().remove("decrementDialValue");
        d.getInputMap(0).remove(KeyStroke.getKeyStroke("DOWN"));
        d.getActionMap().remove("decrementDialValueX4");
        d.getInputMap(0).remove(KeyStroke.getKeyStroke("RIGHT"));
        d.getActionMap().remove("incrementDialValue");
        d.getInputMap(0).remove(KeyStroke.getKeyStroke("UP"));
        d.getActionMap().remove("incrementDialValueX4");
        d.getInputMap(0).remove(KeyStroke.getKeyStroke("HOME"));
        d.getActionMap().remove("setMinimum");
        d.getInputMap(0).remove(KeyStroke.getKeyStroke("END"));
        d.getActionMap().remove("setMaximum");
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.dial.getDialPixmap() != null) {
            return new Dimension(this.dial.getDialPixmap().getIconHeight(), this.dial.getDialPixmap().getIconHeight());
        }
        return new Dimension(32, 32);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (this.dial.getDialPixmap() != null) {
            this.paintPixmapDial(g, c);
            return;
        }
        double k = this.dial.getValue() - this.dial.getMinimum();
        double a = (k /= (double)(this.dial.getMaximum() - this.dial.getMinimum())) * (double)(this.dial.getMaximumAngle() - this.dial.getMinimumAngle()) + (double)this.dial.getMinimumAngle();
        a = Math.toRadians(a);
        double x1 = c.getSize().getWidth() / 2.0;
        double y1 = c.getSize().getHeight() / 2.0;
        double r = Math.min(x1, y1) - 6.0;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color1 = new Color(0xDCDCDC);
        Color color2 = Color.GRAY;
        Color color3 = Color.WHITE;
        GradientPaint gp = new GradientPaint((float)(x1 - r), (float)(y1 - r), color1, (float)x1, (float)y1, color2);
        g2.setPaint(gp);
        Ellipse2D.Double e2 = new Ellipse2D.Double(x1 - r, y1 - r, 2.0 * r, 2.0 * r);
        g2.fill(e2);
        gp = new GradientPaint((float)(x1 + r), (float)(y1 + r), color1, (float)x1, (float)y1, color3);
        g2.setPaint(gp);
        double r2 = r - r / 4.0;
        e2 = new Ellipse2D.Double(x1 - r2, y1 - r2, 2.0 * r2, 2.0 * r2);
        g2.fill(e2);
        double thumbStart = r - (r - r2) - r / 2.2;
        double thumbEnd = r - (r - r2) - r / 7.0;
        Line2D.Double l2 = new Line2D.Double(x1 - thumbStart * Math.sin(a), y1 + thumbStart * Math.cos(a), x1 - thumbEnd * Math.sin(a), y1 + thumbEnd * Math.cos(a));
        g2.setStroke(new BasicStroke(2.0f));
        g2.setPaint(color2);
        g2.draw(l2);
    }

    protected void paintPixmapDial(Graphics g, JComponent c) {
        boolean rollover;
        boolean pressed = this.trackListener.isButtonDown();
        boolean bl = rollover = this.trackListener.isMouseOver() || this.trackListener.isButtonDown();
        ImageIcon dpm = !this.dial.isEnabled() ? (this.dial.getDisabledDialPixmap() != null ? this.dial.getDisabledDialPixmap() : this.dial.getDialPixmap()) : (pressed && this.dial.getPressedDialPixmap() != null ? this.dial.getPressedDialPixmap() : (rollover && this.dial.getRolloverDialPixmap() != null ? this.dial.getRolloverDialPixmap() : this.dial.getDialPixmap()));
        int h = dpm.getIconHeight();
        int w = dpm.getIconWidth();
        int n = w / h;
        double k = this.dial.getValue() - this.dial.getMinimum();
        int i = (int)((double)(n - 1) * (k /= (double)(this.dial.getMaximum() - this.dial.getMinimum())));
        g.drawImage(dpm.getImage(), 0, 0, h, h, i * h, 0, i * h + h, h, c);
    }

    protected void processMouseDragging(Point oldMousePosition, Point newMousePosition) {
        int oldX = oldMousePosition.x;
        int oldY = oldMousePosition.y;
        int newX = newMousePosition.x;
        int newY = newMousePosition.y;
        switch (this.dial.getMouseHandlerMode()) {
            case LEFT_TO_RIGHT: {
                if (newX == oldX) break;
                this.dial.setValue(this.dial.getValue() + (newX > oldX ? 1 : -1));
                break;
            }
            case RIGHT_TO_LEFT: {
                if (newX == oldX) break;
                this.dial.setValue(this.dial.getValue() + (newX > oldX ? -1 : 1));
                break;
            }
            case DOWN_TO_UP: {
                if (newY == oldY) break;
                this.dial.setValue(this.dial.getValue() + (newY < oldY ? 1 : -1));
                break;
            }
            case UP_TO_DOWN: {
                if (newY == oldY) break;
                this.dial.setValue(this.dial.getValue() + (newY < oldY ? -1 : 1));
                break;
            }
            case LEFT_TO_RIGHT_AND_DOWN_TO_UP: {
                if (newX != oldX) {
                    this.dial.setValue(this.dial.getValue() + (newX > oldX ? 1 : -1));
                }
                if (newY == oldY) break;
                this.dial.setValue(this.dial.getValue() + (newY < oldY ? 1 : -1));
                break;
            }
            case LEFT_TO_RIGHT_AND_UP_TO_DOWN: {
                if (newX != oldX) {
                    this.dial.setValue(this.dial.getValue() + (newX > oldX ? 1 : -1));
                }
                if (newY == oldY) break;
                this.dial.setValue(this.dial.getValue() + (newY < oldY ? -1 : 1));
                break;
            }
            case RIGHT_TO_LEFT_AND_DOWN_TO_UP: {
                if (newX != oldX) {
                    this.dial.setValue(this.dial.getValue() + (newX > oldX ? -1 : 1));
                }
                if (newY == oldY) break;
                this.dial.setValue(this.dial.getValue() + (newY < oldY ? 1 : -1));
                break;
            }
            case RIGHT_TO_LEFT_AND_UP_TO_DOWN: {
                if (newX != oldX) {
                    this.dial.setValue(this.dial.getValue() + (newX > oldX ? -1 : 1));
                }
                if (newY == oldY) break;
                this.dial.setValue(this.dial.getValue() + (newY < oldY ? -1 : 1));
                break;
            }
            case RADIAL: {
                this.dial.setValue(this.getValueByPoint(newMousePosition));
            }
        }
    }

    @Override
    public int getValueByPoint(Point p) {
        if (p == null) {
            throw new IllegalArgumentException("p should be non-null!");
        }
        double x = p.x - this.dial.getSize().height / 2;
        double y = this.dial.getSize().height / 2 - p.y;
        double angle = Math.toDegrees(Math.atan2(x, y)) + 180.0;
        int min = this.dial.getMinimum();
        int max = this.dial.getMaximum();
        int range = this.dial.getMaximumAngle() - this.dial.getMinimumAngle();
        if ((angle -= (double)this.dial.getMinimumAngle()) < 0.0) {
            angle = 0.0;
        } else if (angle > (double)range) {
            angle = range;
        }
        return (int)((double)(max - min) * (angle / (double)range) + (double)min);
    }

    private Handler getHandler() {
        return this.handler;
    }

    private class Handler
    implements ChangeListener {
        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            BasicDialUI.this.dial.repaint();
        }
    }

    private class TrackListener
    extends MouseInputAdapter {
        private transient int currentMouseX = 0;
        private transient int currentMouseY = 0;
        private boolean mouseOver = false;
        private boolean buttonDown = false;

        private TrackListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if ((e.getModifiersEx() & 0x400) != 1024) {
                return;
            }
            if (!BasicDialUI.this.dial.isEnabled()) {
                return;
            }
            Point oldPoint = new Point(this.currentMouseX, this.currentMouseY);
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            Point newPoint = new Point(this.currentMouseX, this.currentMouseY);
            BasicDialUI.this.processMouseDragging(oldPoint, newPoint);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseOver = true;
            BasicDialUI.this.dial.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseOver = false;
            BasicDialUI.this.dial.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!BasicDialUI.this.dial.hasFocus() && BasicDialUI.this.dial.isRequestFocusEnabled()) {
                BasicDialUI.this.dial.requestFocus();
            }
            if (e.getButton() != 1) {
                return;
            }
            this.buttonDown = true;
            BasicDialUI.this.dial.repaint();
            BasicDialUI.this.dial.setValueIsAdjusting(true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            this.buttonDown = false;
            BasicDialUI.this.dial.repaint();
            BasicDialUI.this.dial.setValueIsAdjusting(false);
        }

        public boolean isMouseOver() {
            return this.mouseOver;
        }

        public boolean isButtonDown() {
            return this.buttonDown;
        }
    }

    private static class Actions
    extends AbstractAction {
        private static final String DECREMENT = "decrementDialValue";
        private static final String DECREMENT_X4 = "decrementDialValueX4";
        private static final String INCREMENT = "incrementDialValue";
        private static final String INCREMENT_X4 = "incrementDialValueX4";
        private static final String SET_MINIMUM = "setMinimum";
        private static final String SET_MAXIMUM = "setMaximum";

        Actions(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String key = this.getValue("Name").toString();
            Dial dial = (Dial)e.getSource();
            if (key == DECREMENT) {
                int v = dial.getValue();
                if (v > dial.getMinimum()) {
                    dial.setValue(v - 1);
                }
            } else if (key == DECREMENT_X4) {
                int v = dial.getValue() - 4;
                dial.setValue(v < dial.getMinimum() ? dial.getMinimum() : v);
            } else if (key == INCREMENT) {
                int v = dial.getValue();
                if (v < dial.getMaximum()) {
                    dial.setValue(v + 1);
                }
            } else if (key == INCREMENT_X4) {
                int v = dial.getValue() + 4;
                dial.setValue(v > dial.getMaximum() ? dial.getMaximum() : v);
            } else if (key == SET_MINIMUM) {
                dial.setValue(dial.getMinimum());
            } else if (key == SET_MAXIMUM) {
                dial.setValue(dial.getMaximum());
            }
        }
    }
}

