/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCache;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheType;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public abstract class AbstractRemoteCacheNoWaitFacade<K, V>
extends AbstractAuxiliaryCache<K, V> {
    private static final Log log = LogManager.getLog(AbstractRemoteCacheNoWaitFacade.class);
    protected List<RemoteCacheNoWait<K, V>> noWaits;
    private final IRemoteCacheAttributes remoteCacheAttributes;

    public AbstractRemoteCacheNoWaitFacade(List<RemoteCacheNoWait<K, V>> noWaits, IRemoteCacheAttributes rca, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        log.debug("CONSTRUCTING NO WAIT FACADE");
        this.remoteCacheAttributes = rca;
        this.setCacheEventLogger(cacheEventLogger);
        this.setElementSerializer(elementSerializer);
        this.noWaits = new ArrayList<RemoteCacheNoWait<K, V>>(noWaits);
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            ((RemoteCache)nw.getRemoteCache()).setFacade(this);
        }
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.noWaits::size;
        log.debug("updating through cache facade, noWaits.length = {0}", supplierArray);
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            nw.update(ce);
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) throws IOException {
        Iterator<RemoteCacheNoWait<K, V>> iterator = this.noWaits.iterator();
        if (iterator.hasNext()) {
            RemoteCacheNoWait<K, V> nw = iterator.next();
            return nw.get(key);
        }
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) throws IOException {
        Iterator<RemoteCacheNoWait<K, V>> iterator = this.noWaits.iterator();
        if (iterator.hasNext()) {
            RemoteCacheNoWait<K, V> nw = iterator.next();
            return nw.getMatching(pattern);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) throws IOException {
        Iterator<RemoteCacheNoWait<K, V>> iterator;
        if (keys != null && !keys.isEmpty() && (iterator = this.noWaits.iterator()).hasNext()) {
            RemoteCacheNoWait<K, V> nw = iterator.next();
            return nw.getMultiple(keys);
        }
        return Collections.emptyMap();
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet<K> allKeys = new HashSet<K>();
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            Set<K> keys = nw.getKeySet();
            if (keys == null) continue;
            allKeys.addAll(keys);
        }
        return allKeys;
    }

    @Override
    public boolean remove(K key) throws IOException {
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            nw.remove(key);
        }
        return false;
    }

    @Override
    public void removeAll() throws IOException {
        for (RemoteCacheNoWait<K, V> nw : this.noWaits) {
            nw.removeAll();
        }
    }

    @Override
    public void dispose() {
        this.noWaits.forEach(RemoteCacheNoWait::dispose);
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.REMOTE_CACHE;
    }

    @Override
    public String getCacheName() {
        return this.remoteCacheAttributes.getCacheName();
    }

    @Override
    public CacheStatus getStatus() {
        return this.noWaits.stream().map(nw -> nw.getStatus()).filter(status -> status == CacheStatus.ALIVE).findFirst().orElse(CacheStatus.DISPOSED);
    }

    public String toString() {
        return "RemoteCacheNoWaitFacade: " + this.remoteCacheAttributes.getCacheName() + ", rca = " + this.remoteCacheAttributes;
    }

    protected abstract void failover(RemoteCacheNoWait<K, V> var1);

    public RemoteCacheNoWait<K, V> getPrimaryServer() {
        return this.noWaits.get(0);
    }

    public void restorePrimaryServer(RemoteCacheNoWait<K, V> rcnw) {
        this.noWaits.clear();
        this.noWaits.add(rcnw);
    }

    @Override
    public IRemoteCacheAttributes getAuxiliaryCacheAttributes() {
        return this.remoteCacheAttributes;
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait Facade");
        ArrayList elems = new ArrayList();
        if (this.noWaits != null) {
            elems.add(new StatElement<Integer>("Number of No Waits", this.noWaits.size()));
            elems.addAll(this.noWaits.stream().flatMap(rcnw -> rcnw.getStatistics().getStatElements().stream()).collect(Collectors.toList()));
        }
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return "Remote Cache No Wait Facade";
    }
}

