/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the square root of the sum of squares of corresponding input
pixels.


This filter is templated over the types of the two input images and
the type of the output image.

Numeric conversions (castings) are done by the C++ defaults.

The filter walks over all of the pixels in the two input images, and
for each pixel does the following:


cast the input 1 pixel value to double

cast the input 2 pixel value to double

compute the sum of squares of the two pixel values

compute the square root of the sum

cast the double value resulting from std::sqrt() to the pixel type of
the output image

store the cast value into the output image.
 The filter expects all images to have the same dimension (e.g. all
2D, or all 3D, or all ND)
See:
 itk::simple::BinaryMagnitude for the procedural interface

 itk::BinaryMagnitudeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryMagnitudeImageFilter.h
*/
public class BinaryMagnitudeImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryMagnitudeImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryMagnitudeImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryMagnitudeImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryMagnitudeImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryMagnitudeImageFilter::~BinaryMagnitudeImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryMagnitudeImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryMagnitudeImageFilter::BinaryMagnitudeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryMagnitudeImageFilter() {
    this(SimpleITKJNI.new_BinaryMagnitudeImageFilter(), true);
  }

  /**
std::string itk::simple::BinaryMagnitudeImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryMagnitudeImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryMagnitudeImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryMagnitudeImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryMagnitudeImageFilter::Execute(Image &amp;&amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.BinaryMagnitudeImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

}
