/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.session;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.analysis.checkers.FirIdentityLessPlatformDeterminer;
import org.jetbrains.kotlin.fir.analysis.checkers.FirPlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsIdentityLessPlatformDeterminer;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsModuleKind;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsPlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.fir.checkers.CheckersContainersKt;
import org.jetbrains.kotlin.fir.declarations.FirTypeSpecificityComparatorProvider;
import org.jetbrains.kotlin.fir.deserialization.FirTypeDeserializer;
import org.jetbrains.kotlin.fir.resolve.calls.js.JsCallConflictResolverFactory;
import org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeCallConflictResolverFactory;
import org.jetbrains.kotlin.fir.scopes.FirDefaultImportProviderHolder;
import org.jetbrains.kotlin.fir.session.AbstractFirKlibSessionFactory;
import org.jetbrains.kotlin.fir.session.ComponentsContainersKt;
import org.jetbrains.kotlin.fir.session.FirSessionConfigurator;
import org.jetbrains.kotlin.fir.session.JsFlexibleTypeFactory;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.js.resolve.JsTypeSpecificityComparatorWithoutDelegate;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0014\u0010\f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0014\u0010\u0010\u001a\u00020\r*\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0014\u0010\u0012\u001a\u00020\r*\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0014\u0010\u0013\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0014\u0010\u0014\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0014\u0010\u0016\u001a\u00020\r*\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/session/FirJsSessionFactory;", "Lorg/jetbrains/kotlin/fir/session/AbstractFirKlibSessionFactory;", "Lorg/jetbrains/kotlin/fir/session/FirJsSessionFactory$Context;", "<init>", "()V", "createLibraryContext", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "createFlexibleTypeFactory", "Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer$FlexibleTypeFactory;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "registerLibrarySessionComponents", "", "c", "createSourceContext", "registerPlatformCheckers", "Lorg/jetbrains/kotlin/fir/session/FirSessionConfigurator;", "registerExtraPlatformCheckers", "registerSourceSessionComponents", "registerComponents", "compilerConfiguration", "registerJsComponents", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "Context", "entrypoint"})
public final class FirJsSessionFactory
extends AbstractFirKlibSessionFactory<Context, Context> {
    @NotNull
    public static final FirJsSessionFactory INSTANCE = new FirJsSessionFactory();

    private FirJsSessionFactory() {
    }

    @Override
    @NotNull
    protected Context createLibraryContext(@NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        return new Context(configuration2);
    }

    @Override
    @NotNull
    protected FirTypeDeserializer.FlexibleTypeFactory createFlexibleTypeFactory(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return new JsFlexibleTypeFactory(session2);
    }

    @Override
    protected void registerLibrarySessionComponents(@NotNull FirSession $this$registerLibrarySessionComponents, @NotNull Context c2) {
        Intrinsics.checkNotNullParameter((Object)$this$registerLibrarySessionComponents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        this.registerComponents($this$registerLibrarySessionComponents, c2.getConfiguration());
    }

    @Override
    @NotNull
    protected Context createSourceContext(@NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        return new Context(configuration2);
    }

    @Override
    protected void registerPlatformCheckers(@NotNull FirSessionConfigurator $this$registerPlatformCheckers, @NotNull Context c2) {
        Intrinsics.checkNotNullParameter((Object)$this$registerPlatformCheckers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        CheckersContainersKt.registerJsCheckers($this$registerPlatformCheckers);
    }

    @Override
    protected void registerExtraPlatformCheckers(@NotNull FirSessionConfigurator $this$registerExtraPlatformCheckers, @NotNull Context c2) {
        Intrinsics.checkNotNullParameter((Object)$this$registerExtraPlatformCheckers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
    }

    @Override
    protected void registerSourceSessionComponents(@NotNull FirSession $this$registerSourceSessionComponents, @NotNull Context c2) {
        Intrinsics.checkNotNullParameter((Object)$this$registerSourceSessionComponents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        this.registerComponents($this$registerSourceSessionComponents, c2.getConfiguration());
    }

    private final void registerComponents(FirSession $this$registerComponents, CompilerConfiguration compilerConfiguration) {
        ModuleKind moduleKind = compilerConfiguration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)moduleKind), (String)"get(...)");
        ModuleKind moduleKind2 = moduleKind;
        ComponentsContainersKt.registerDefaultComponents($this$registerComponents);
        this.registerJsComponents($this$registerComponents, moduleKind2);
    }

    public final void registerJsComponents(@NotNull FirSession $this$registerJsComponents, @Nullable ModuleKind moduleKind) {
        Intrinsics.checkNotNullParameter((Object)$this$registerJsComponents, (String)"<this>");
        $this$registerJsComponents.register((KClass<? extends FirSessionComponent>)Reflection.getOrCreateKotlinClass(ConeCallConflictResolverFactory.class), (FirSessionComponent)JsCallConflictResolverFactory.INSTANCE);
        $this$registerJsComponents.register((KClass<? extends FirSessionComponent>)Reflection.getOrCreateKotlinClass(FirTypeSpecificityComparatorProvider.class), (FirSessionComponent)new FirTypeSpecificityComparatorProvider(new JsTypeSpecificityComparatorWithoutDelegate(TypeComponentsKt.getTypeContext($this$registerJsComponents))));
        $this$registerJsComponents.register((KClass<? extends FirSessionComponent>)Reflection.getOrCreateKotlinClass(FirPlatformDiagnosticSuppressor.class), (FirSessionComponent)new FirJsPlatformDiagnosticSuppressor());
        $this$registerJsComponents.register((KClass<? extends FirSessionComponent>)Reflection.getOrCreateKotlinClass(FirIdentityLessPlatformDeterminer.class), (FirSessionComponent)FirJsIdentityLessPlatformDeterminer.INSTANCE);
        if (moduleKind != null) {
            $this$registerJsComponents.register((KClass<? extends FirSessionComponent>)Reflection.getOrCreateKotlinClass(FirJsModuleKind.class), (FirSessionComponent)new FirJsModuleKind(moduleKind));
        }
        $this$registerJsComponents.register((KClass<? extends FirSessionComponent>)Reflection.getOrCreateKotlinClass(FirDefaultImportProviderHolder.class), (FirSessionComponent)new FirDefaultImportProviderHolder(JsPlatformAnalyzerServices.INSTANCE));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/session/FirJsSessionFactory$Context;", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "getConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "entrypoint"})
    public static final class Context {
        @NotNull
        private final CompilerConfiguration configuration;

        public Context(@NotNull CompilerConfiguration configuration2) {
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            this.configuration = configuration2;
        }

        @NotNull
        public final CompilerConfiguration getConfiguration() {
            return this.configuration;
        }
    }
}

