/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme.internal.laftheme;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.infonode.gui.DynamicUIManager;
import net.infonode.gui.DynamicUIManagerListener;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneHandlerListener;
import net.infonode.tabbedpanel.theme.internal.laftheme.PanePainter;
import net.infonode.util.Direction;

public class PaneHandler {
    private JFrame frame;
    private PanePainter[] panePainters;
    private PaneHandlerListener listener;
    private DynamicUIManagerListener uiListener = new DynamicUIManagerListener(){

        @Override
        public void lookAndFeelChanged() {
            PaneHandler.this.doUpdate();
        }

        @Override
        public void propertiesChanging() {
            PaneHandler.this.listener.updating();
        }

        @Override
        public void propertiesChanged() {
            PaneHandler.this.doUpdate();
        }

        @Override
        public void lookAndFeelChanging() {
            PaneHandler.this.listener.updating();
        }
    };

    PaneHandler(PaneHandlerListener listener) {
        this.listener = listener;
        DynamicUIManager.getInstance().addPrioritizedListener(this.uiListener);
        Direction[] directions = Direction.getDirections();
        this.panePainters = new PanePainter[directions.length];
        JPanel panel = new JPanel(null);
        int i = 0;
        while (i < directions.length) {
            this.panePainters[i] = new PanePainter(directions[i]);
            panel.add(this.panePainters[i]);
            this.panePainters[i].setBounds(0, 0, 600, 600);
            ++i;
        }
        this.frame = new JFrame();
        this.frame.getContentPane().add((Component)panel, "Center");
        this.frame.pack();
    }

    void dispose() {
        if (this.frame != null) {
            DynamicUIManager.getInstance().removePrioritizedListener(this.uiListener);
            this.frame.removeAll();
            this.frame.dispose();
            this.frame = null;
        }
    }

    PanePainter getPainter(Direction d) {
        int i = 0;
        while (i < this.panePainters.length) {
            if (this.panePainters[i].getDirection() == d) {
                return this.panePainters[i];
            }
            ++i;
        }
        return null;
    }

    JFrame getFrame() {
        return this.frame;
    }

    void update() {
        this.listener.updating();
        this.doUpdate();
    }

    private void doUpdate() {
        SwingUtilities.updateComponentTreeUI(this.frame);
        this.listener.updated();
    }
}

