/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarServiceProvider {
    public static final String SERVICES_ROOT = "META-INF/services/";
    private static final Logger LOG = Logger.getLogger(JarServiceProvider.class.getName());

    private JarServiceProvider() {
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = JarServiceProvider.class.getClassLoader();
        return cl == null ? ClassLoader.getSystemClassLoader() : cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> getServiceProviders(Class cls) throws IOException {
        ArrayList<Object> l = new ArrayList<Object>();
        ClassLoader cl = JarServiceProvider.getClassLoader();
        String serviceFile = SERVICES_ROOT + cls.getName();
        Enumeration<URL> e = cl.getResources(serviceFile);
        while (e.hasMoreElements()) {
            URL u = e.nextElement();
            InputStream is = u.openStream();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
                String str = null;
                while ((str = br.readLine()) != null) {
                    int commentStartIdx = str.indexOf("#");
                    if (commentStartIdx != -1) {
                        str = str.substring(0, commentStartIdx);
                    }
                    if ((str = str.trim()).length() == 0) continue;
                    try {
                        Object obj = cl.loadClass(str).newInstance();
                        l.add(obj);
                    }
                    catch (Exception ex) {
                        LOG.warning("Could not load: " + str);
                        LOG.warning(ex.getMessage());
                    }
                }
            }
            finally {
                if (br == null) continue;
                br.close();
            }
        }
        return l;
    }

    public static Properties readProperties(Class clazz) {
        return JarServiceProvider.readProperties(clazz.getName());
    }

    public static Properties readProperties(String name) {
        InputStream is;
        Properties props = new Properties();
        String serviceFile = name.toLowerCase();
        if (!serviceFile.endsWith(".properties")) {
            serviceFile = serviceFile + ".properties";
        }
        if ((is = JarServiceProvider.findResource(serviceFile)) != null) {
            try {
                props.load(new InputStreamReader(is, "UTF-8"));
            }
            catch (IOException ex) {
                Logger.getLogger(JarServiceProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return props;
    }

    public static Properties readProperties(String name, Locale locale) {
        int idx = (name = name.toLowerCase()).lastIndexOf(".properties");
        if (idx > 0) {
            name = name.substring(0, idx);
        }
        Properties props = JarServiceProvider.readProperties(name);
        if (locale != null && locale.getLanguage() != null) {
            name = name + "_" + locale.getLanguage();
            Properties langProps = JarServiceProvider.readProperties(name);
            props.putAll((Map<?, ?>)langProps);
        }
        if (locale != null && locale.getCountry() != null) {
            name = name + "_" + locale.getCountry();
            Properties countryProps = JarServiceProvider.readProperties(name);
            props.putAll((Map<?, ?>)countryProps);
        }
        return props;
    }

    public static Map<String, String> readStringsMap(String name) {
        Properties props = JarServiceProvider.readProperties(name);
        HashMap<String, String> map = new HashMap<String, String>();
        if (props != null) {
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                map.put(e.getKey().toString(), e.getValue().toString());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(String url) {
        InputStream is = JarServiceProvider.findResource(url);
        if (is == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                line = line.trim().replace("\\n", "\n").replace("\\t", "\t");
                lines.add(line);
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            return lines;
        }
    }

    public static InputStream findResource(String url, ClassLoader cl) {
        InputStream is = null;
        URL loc = cl.getResource(url);
        if (loc == null) {
            loc = cl.getResource(SERVICES_ROOT + url);
        }
        if (loc == null) {
            is = ClassLoader.getSystemResourceAsStream(url);
        } else {
            try {
                is = loc.openStream();
            }
            catch (IOException ex) {
                Logger.getLogger(JarServiceProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return is;
    }

    public static InputStream findResource(String url) {
        return JarServiceProvider.findResource(url, JarServiceProvider.getClassLoader());
    }
}

