/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.geom;

import com.jogamp.graph.geom.Vertex;
import com.jogamp.graph.geom.plane.AffineTransform;
import com.jogamp.graph.geom.plane.Winding;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;

public class Outline
implements Comparable<Outline> {
    private ArrayList<Vertex> vertices;
    private boolean closed;
    private final AABBox bbox;
    private boolean dirtyBBox;
    private Winding winding;
    private boolean dirtyWinding;

    public Outline() {
        this.vertices = new ArrayList(3);
        this.closed = false;
        this.bbox = new AABBox();
        this.dirtyBBox = false;
        this.winding = Winding.CCW;
        this.dirtyWinding = false;
    }

    public Outline(Outline outline) {
        int n = outline.vertices.size();
        this.vertices = new ArrayList(n);
        this.winding = outline.getWinding();
        this.dirtyWinding = false;
        for (int i = 0; i < n; ++i) {
            this.vertices.add(outline.vertices.get(i).clone());
        }
        this.closed = outline.closed;
        this.bbox = new AABBox(outline.bbox);
        this.dirtyBBox = outline.dirtyBBox;
    }

    public Outline(Outline outline, Winding winding) {
        Winding winding2;
        int n = outline.vertices.size();
        this.vertices = new ArrayList(n);
        this.winding = winding2 = outline.getWinding();
        this.dirtyWinding = false;
        if (winding != winding2) {
            for (int i = n - 1; i >= 0; --i) {
                this.vertices.add(outline.vertices.get(i).clone());
            }
            this.winding = winding;
        } else {
            for (int i = 0; i < n; ++i) {
                this.vertices.add(outline.vertices.get(i).clone());
            }
        }
        this.closed = outline.closed;
        this.bbox = new AABBox(outline.bbox);
        this.dirtyBBox = outline.dirtyBBox;
    }

    public final void setWinding(Winding winding) {
        Winding winding2 = this.getWinding();
        if (winding != winding2) {
            int n = this.vertices.size();
            ArrayList<Vertex> arrayList = new ArrayList<Vertex>(n);
            for (int i = n - 1; i >= 0; --i) {
                arrayList.add(this.vertices.get(i));
            }
            this.vertices = arrayList;
            this.winding = winding;
        }
    }

    public final Winding getWinding() {
        if (!this.dirtyWinding) {
            return this.winding;
        }
        int n = this.getVertexCount();
        this.winding = 3 > n ? Winding.CCW : VectorUtil.getWinding(this.getVertices());
        this.dirtyWinding = false;
        return this.winding;
    }

    public final int getVertexCount() {
        return this.vertices.size();
    }

    public final void addVertex(Vertex vertex) throws NullPointerException {
        this.addVertex(this.vertices.size(), vertex);
    }

    public final void addVertex(int n, Vertex vertex) throws NullPointerException, IndexOutOfBoundsException {
        if (null == vertex) {
            throw new NullPointerException("vertex is null");
        }
        this.vertices.add(n, vertex);
        if (!this.dirtyBBox) {
            this.bbox.resize(vertex.getCoord());
        }
        this.dirtyWinding = true;
    }

    public final void setVertex(int n, Vertex vertex) throws NullPointerException, IndexOutOfBoundsException {
        if (null == vertex) {
            throw new NullPointerException("vertex is null");
        }
        this.vertices.set(n, vertex);
        this.dirtyBBox = true;
        this.dirtyWinding = true;
    }

    public final Vertex getVertex(int n) {
        return this.vertices.get(n);
    }

    public int getVertexIndex(Vertex vertex) {
        return this.vertices.indexOf(vertex);
    }

    public final Vertex removeVertex(int n) throws IndexOutOfBoundsException {
        this.dirtyBBox = true;
        this.dirtyWinding = true;
        return this.vertices.remove(n);
    }

    public final boolean isEmpty() {
        return this.vertices.size() == 0;
    }

    public final Vertex getLastVertex() {
        if (this.isEmpty()) {
            return null;
        }
        return this.vertices.get(this.vertices.size() - 1);
    }

    public final ArrayList<Vertex> getVertices() {
        return this.vertices;
    }

    public final void setVertices(ArrayList<Vertex> arrayList) {
        this.vertices = arrayList;
        this.validateBoundingBox();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final boolean setClosed(boolean bl) {
        this.closed = true;
        if (!this.isEmpty()) {
            Vertex vertex = this.vertices.get(0);
            Vertex vertex2 = this.getLastVertex();
            if (!vertex.getCoord().isEqual(vertex2.getCoord())) {
                if (bl) {
                    this.vertices.add(vertex.clone());
                } else {
                    this.vertices.add(0, vertex2.clone());
                }
                return true;
            }
        }
        return false;
    }

    public final Outline transform(AffineTransform affineTransform) {
        Outline outline = new Outline();
        int n = this.vertices.size();
        for (int i = 0; i < n; ++i) {
            Vertex vertex = this.vertices.get(i);
            outline.addVertex(affineTransform.transform(vertex, new Vertex()));
        }
        outline.closed = this.closed;
        return outline;
    }

    private final void validateBoundingBox() {
        this.dirtyBBox = false;
        this.bbox.reset();
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.bbox.resize(this.vertices.get(i).getCoord());
        }
    }

    public final AABBox getBounds() {
        if (this.dirtyBBox) {
            this.validateBoundingBox();
        }
        return this.bbox;
    }

    @Override
    public final int compareTo(Outline outline) {
        float f;
        float f2 = this.getBounds().getSize();
        if (FloatUtil.isEqual(f2, f = outline.getBounds().getSize(), 1.1920929E-7f)) {
            return 0;
        }
        if (f2 < f) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof Outline)) {
            return false;
        }
        Outline outline = (Outline)object;
        if (this.getVertexCount() != outline.getVertexCount()) {
            return false;
        }
        if (!this.getBounds().equals(outline.getBounds())) {
            return false;
        }
        for (int i = this.getVertexCount() - 1; i >= 0; --i) {
            if (this.getVertex(i).equals(outline.getVertex(i))) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(super.hashCode());
    }
}

