/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream128;
import com.dynatrace.hash4j.hashing.AbstractHasher128;
import com.dynatrace.hash4j.hashing.HashStream128;
import com.dynatrace.hash4j.hashing.HashValue128;
import com.dynatrace.hash4j.hashing.Hasher128;
import com.dynatrace.hash4j.hashing.XXH3Base;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.UnsignedMultiplyUtil;

class XXH3_128
extends XXH3Base
implements AbstractHasher128 {
    private final long secShift12;
    private final long secShift13;
    private final long secShift14;
    private final long secShift15;
    private final long secShiftFinal8;
    private final long secShiftFinal9;
    private final long secShiftFinal10;
    private final long secShiftFinal11;
    private final long secShiftFinal12;
    private final long secShiftFinal13;
    private final long secShiftFinal14;
    private final long secShiftFinal15;
    private final long bitflip00;
    private final long bitflip11;
    private final long bitflip23;
    private final long bitflip45;
    private final long bitflip67;
    private final HashValue128 hash0;
    private final long seed;
    private static final Hasher128 DEFAULT_HASHER_INSTANCE = new XXH3_128();

    private XXH3_128(long seed) {
        super(seed);
        this.secShift12 = 5695865814404364607L - seed;
        this.secShift13 = 6464017090953185821L + seed;
        this.secShift14 = 8320639771003045937L - seed;
        this.secShift15 = -1453760514566526364L + seed;
        this.seed = seed;
        this.secShiftFinal8 = this.secret14 >>> 40 | this.secret15 << 24;
        this.secShiftFinal9 = this.secret15 >>> 40 | this.secret16 << 24;
        this.secShiftFinal10 = this.secret16 >>> 40 | this.secret17 << 24;
        this.secShiftFinal11 = this.secret17 >>> 40 | this.secret18 << 24;
        this.secShiftFinal12 = this.secret18 >>> 40 | this.secret19 << 24;
        this.secShiftFinal13 = this.secret19 >>> 40 | this.secret20 << 24;
        this.secShiftFinal14 = this.secret20 >>> 40 | this.secret21 << 24;
        this.secShiftFinal15 = this.secret21 >>> 40 | this.secret22 << 24;
        this.bitflip00 = 2267503259L + seed;
        this.bitflip11 = 808198283L - seed;
        this.bitflip23 = -4255862940314790740L + (seed ^ Long.reverseBytes(seed & 0xFFFFFFFFL));
        this.bitflip45 = 6455697860950631241L - seed;
        this.bitflip67 = -4466874330221494952L + seed;
        this.hash0 = new HashValue128(XXH3_128.avalanche64(seed ^ 0x4EF90DA297486471L ^ 0xD8ACDEA946EF1938L), XXH3_128.avalanche64(seed ^ 0xCB00C391BB52283CL ^ 0xA32E531B8B65D088L));
    }

    private XXH3_128() {
        this(0L);
    }

    public static Hasher128 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    public static Hasher128 create(long seed) {
        return new XXH3_128(seed);
    }

    @Override
    public HashStream128 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    public HashValue128 hashBytesTo128Bits(byte[] input, int off, int length) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int offStripe;
        int s;
        int offBlock;
        if (length <= 16) {
            if (length > 8) {
                long hi = ByteArrayUtil.getLong(input, off + length - 8);
                long lo = ByteArrayUtil.getLong(input, off) ^ hi ^ this.bitflip45;
                long m128Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(lo, -7046029288634856825L) + (hi ^= this.bitflip67) + (hi & 0xFFFFFFFFL) * 2246822518L;
                long m128Lo = lo * -7046029288634856825L + ((long)length - 1L << 54) ^ Long.reverseBytes(m128Hi);
                long low = XXH3_128.avalanche3(m128Lo * -4417276706812531889L);
                long high = XXH3_128.avalanche3(UnsignedMultiplyUtil.unsignedMultiplyHigh(m128Lo, -4417276706812531889L) + m128Hi * -4417276706812531889L);
                return new HashValue128(high, low);
            }
            if (length >= 4) {
                long lo = (long)ByteArrayUtil.getInt(input, off) & 0xFFFFFFFFL;
                long hi = ByteArrayUtil.getInt(input, off + length - 4);
                long keyed = lo + (hi << 32) ^ this.bitflip23;
                long pl = -7046029288634856825L + (long)(length << 2);
                long low = keyed * pl;
                long high = UnsignedMultiplyUtil.unsignedMultiplyHigh(keyed, pl) + (low << 1);
                low ^= high >>> 3;
                low ^= low >>> 35;
                low *= -6939452855193903323L;
                low ^= low >>> 28;
                high = XXH3_128.avalanche3(high);
                return new HashValue128(high, low);
            }
            if (length != 0) {
                int c1 = input[off] & 0xFF;
                byte c2 = input[off + (length >> 1)];
                int c3 = input[off + length - 1] & 0xFF;
                int combinedl = c1 << 16 | c2 << 24 | c3 | length << 8;
                int combinedh = Integer.rotateLeft(Integer.reverseBytes(combinedl), 13);
                long low = XXH3_128.avalanche64((long)combinedl & 0xFFFFFFFFL ^ this.bitflip00);
                long high = XXH3_128.avalanche64((long)combinedh & 0xFFFFFFFFL ^ this.bitflip11);
                return new HashValue128(high, low);
            }
            return this.hash0;
        }
        if (length <= 128) {
            long b32;
            long b22;
            long b12;
            long b02;
            long acc0 = (long)length * -7046029288634856825L;
            long acc1 = 0L;
            if (length > 32) {
                if (length > 64) {
                    if (length > 96) {
                        b02 = ByteArrayUtil.getLong(input, off + 48);
                        b12 = ByteArrayUtil.getLong(input, off + 56);
                        b22 = ByteArrayUtil.getLong(input, off + length - 64);
                        b32 = ByteArrayUtil.getLong(input, off + length - 56);
                        acc0 = acc0 + XXH3_128.mix2Accs(b02, b12, this.secret12, this.secret13) ^ b22 + b32;
                        acc1 = acc1 + XXH3_128.mix2Accs(b22, b32, this.secret14, this.secret15) ^ b02 + b12;
                    }
                    b02 = ByteArrayUtil.getLong(input, off + 32);
                    b12 = ByteArrayUtil.getLong(input, off + 40);
                    b22 = ByteArrayUtil.getLong(input, off + length - 48);
                    b32 = ByteArrayUtil.getLong(input, off + length - 40);
                    acc0 = acc0 + XXH3_128.mix2Accs(b02, b12, this.secret08, this.secret09) ^ b22 + b32;
                    acc1 = acc1 + XXH3_128.mix2Accs(b22, b32, this.secret10, this.secret11) ^ b02 + b12;
                }
                b02 = ByteArrayUtil.getLong(input, off + 16);
                b12 = ByteArrayUtil.getLong(input, off + 24);
                b22 = ByteArrayUtil.getLong(input, off + length - 32);
                b32 = ByteArrayUtil.getLong(input, off + length - 24);
                acc0 = acc0 + XXH3_128.mix2Accs(b02, b12, this.secret04, this.secret05) ^ b22 + b32;
                acc1 = acc1 + XXH3_128.mix2Accs(b22, b32, this.secret06, this.secret07) ^ b02 + b12;
            }
            b02 = ByteArrayUtil.getLong(input, off);
            b12 = ByteArrayUtil.getLong(input, off + 8);
            b22 = ByteArrayUtil.getLong(input, off + length - 16);
            b32 = ByteArrayUtil.getLong(input, off + length - 8);
            acc0 = acc0 + XXH3_128.mix2Accs(b02, b12, this.secret00, this.secret01) ^ b22 + b32;
            acc1 = acc1 + XXH3_128.mix2Accs(b22, b32, this.secret02, this.secret03) ^ b02 + b12;
            long low = XXH3_128.avalanche3(acc0 + acc1);
            long high = -XXH3_128.avalanche3(acc0 * -7046029288634856825L + acc1 * -8796714831421723037L + ((long)length - this.seed) * -4417276706812531889L);
            return new HashValue128(high, low);
        }
        if (length <= 240) {
            long acc0 = (long)length * -7046029288634856825L;
            long acc1 = 0L;
            long b03 = ByteArrayUtil.getLong(input, off);
            long b13 = ByteArrayUtil.getLong(input, off + 8);
            long b23 = ByteArrayUtil.getLong(input, off + 16);
            long b33 = ByteArrayUtil.getLong(input, off + 24);
            acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secret00, this.secret01) ^ b23 + b33;
            acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secret02, this.secret03) ^ b03 + b13;
            b03 = ByteArrayUtil.getLong(input, off + 32);
            b13 = ByteArrayUtil.getLong(input, off + 40);
            b23 = ByteArrayUtil.getLong(input, off + 48);
            b33 = ByteArrayUtil.getLong(input, off + 56);
            acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secret04, this.secret05) ^ b23 + b33;
            acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secret06, this.secret07) ^ b03 + b13;
            b03 = ByteArrayUtil.getLong(input, off + 64);
            b13 = ByteArrayUtil.getLong(input, off + 72);
            b23 = ByteArrayUtil.getLong(input, off + 80);
            b33 = ByteArrayUtil.getLong(input, off + 88);
            acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secret08, this.secret09) ^ b23 + b33;
            acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secret10, this.secret11) ^ b03 + b13;
            b03 = ByteArrayUtil.getLong(input, off + 96);
            b13 = ByteArrayUtil.getLong(input, off + 104);
            b23 = ByteArrayUtil.getLong(input, off + 112);
            b33 = ByteArrayUtil.getLong(input, off + 120);
            acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secret12, this.secret13) ^ b23 + b33;
            acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secret14, this.secret15) ^ b03 + b13;
            acc0 = XXH3_128.avalanche3(acc0);
            acc1 = XXH3_128.avalanche3(acc1);
            if (160 <= length) {
                b03 = ByteArrayUtil.getLong(input, off + 128);
                b13 = ByteArrayUtil.getLong(input, off + 136);
                b23 = ByteArrayUtil.getLong(input, off + 144);
                b33 = ByteArrayUtil.getLong(input, off + 152);
                acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secShift00, this.secShift01) ^ b23 + b33;
                acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secShift02, this.secShift03) ^ b03 + b13;
            }
            if (192 <= length) {
                b03 = ByteArrayUtil.getLong(input, off + 160);
                b13 = ByteArrayUtil.getLong(input, off + 168);
                b23 = ByteArrayUtil.getLong(input, off + 176);
                b33 = ByteArrayUtil.getLong(input, off + 184);
                acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secShift04, this.secShift05) ^ b23 + b33;
                acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secShift06, this.secShift07) ^ b03 + b13;
            }
            if (224 <= length) {
                b03 = ByteArrayUtil.getLong(input, off + 192);
                b13 = ByteArrayUtil.getLong(input, off + 200);
                b23 = ByteArrayUtil.getLong(input, off + 208);
                b33 = ByteArrayUtil.getLong(input, off + 216);
                acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secShift08, this.secShift09) ^ b23 + b33;
                acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secShift10, this.secShift11) ^ b03 + b13;
            }
            b03 = ByteArrayUtil.getLong(input, off + length - 16);
            b13 = ByteArrayUtil.getLong(input, off + length - 8);
            b23 = ByteArrayUtil.getLong(input, off + length - 32);
            b33 = ByteArrayUtil.getLong(input, off + length - 24);
            acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secShift12, this.secShift13) ^ b23 + b33;
            acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secShift14, this.secShift15) ^ b03 + b13;
            long low = XXH3_128.avalanche3(acc0 + acc1);
            long high = -XXH3_128.avalanche3(acc0 * -7046029288634856825L + acc1 * -8796714831421723037L + ((long)length - this.seed) * -4417276706812531889L);
            return new HashValue128(high, low);
        }
        long acc0 = 3266489917L;
        long acc1 = -7046029288634856825L;
        long acc2 = -4417276706812531889L;
        long acc3 = 1609587929392839161L;
        long acc4 = -8796714831421723037L;
        long acc5 = 2246822519L;
        long acc6 = 2870177450012600261L;
        long acc7 = 2654435761L;
        int nbBlocks = length - 1 >>> 10;
        for (int n = 0; n < nbBlocks; ++n) {
            offBlock = off + (n << 10);
            for (s = 0; s < 16; ++s) {
                offStripe = offBlock + (s << 6);
                b0 = ByteArrayUtil.getLong(input, offStripe + 0);
                b1 = ByteArrayUtil.getLong(input, offStripe + 8);
                b2 = ByteArrayUtil.getLong(input, offStripe + 16);
                b3 = ByteArrayUtil.getLong(input, offStripe + 24);
                b4 = ByteArrayUtil.getLong(input, offStripe + 32);
                b5 = ByteArrayUtil.getLong(input, offStripe + 40);
                b6 = ByteArrayUtil.getLong(input, offStripe + 48);
                b7 = ByteArrayUtil.getLong(input, offStripe + 56);
                acc0 += b1 + XXH3_128.contrib(b0, this.secret[s + 0]);
                acc1 += b0 + XXH3_128.contrib(b1, this.secret[s + 1]);
                acc2 += b3 + XXH3_128.contrib(b2, this.secret[s + 2]);
                acc3 += b2 + XXH3_128.contrib(b3, this.secret[s + 3]);
                acc4 += b5 + XXH3_128.contrib(b4, this.secret[s + 4]);
                acc5 += b4 + XXH3_128.contrib(b5, this.secret[s + 5]);
                acc6 += b7 + XXH3_128.contrib(b6, this.secret[s + 6]);
                acc7 += b6 + XXH3_128.contrib(b7, this.secret[s + 7]);
            }
            acc0 = XXH3_128.mixAcc(acc0, this.secret16);
            acc1 = XXH3_128.mixAcc(acc1, this.secret17);
            acc2 = XXH3_128.mixAcc(acc2, this.secret18);
            acc3 = XXH3_128.mixAcc(acc3, this.secret19);
            acc4 = XXH3_128.mixAcc(acc4, this.secret20);
            acc5 = XXH3_128.mixAcc(acc5, this.secret21);
            acc6 = XXH3_128.mixAcc(acc6, this.secret22);
            acc7 = XXH3_128.mixAcc(acc7, this.secret23);
        }
        int nbStripes = length - 1 - (nbBlocks << 10) >>> 6;
        offBlock = off + (nbBlocks << 10);
        for (s = 0; s < nbStripes; ++s) {
            offStripe = offBlock + (s << 6);
            b0 = ByteArrayUtil.getLong(input, offStripe + 0);
            b1 = ByteArrayUtil.getLong(input, offStripe + 8);
            b2 = ByteArrayUtil.getLong(input, offStripe + 16);
            b3 = ByteArrayUtil.getLong(input, offStripe + 24);
            b4 = ByteArrayUtil.getLong(input, offStripe + 32);
            b5 = ByteArrayUtil.getLong(input, offStripe + 40);
            b6 = ByteArrayUtil.getLong(input, offStripe + 48);
            b7 = ByteArrayUtil.getLong(input, offStripe + 56);
            acc0 += b1 + XXH3_128.contrib(b0, this.secret[s + 0]);
            acc1 += b0 + XXH3_128.contrib(b1, this.secret[s + 1]);
            acc2 += b3 + XXH3_128.contrib(b2, this.secret[s + 2]);
            acc3 += b2 + XXH3_128.contrib(b3, this.secret[s + 3]);
            acc4 += b5 + XXH3_128.contrib(b4, this.secret[s + 4]);
            acc5 += b4 + XXH3_128.contrib(b5, this.secret[s + 5]);
            acc6 += b7 + XXH3_128.contrib(b6, this.secret[s + 6]);
            acc7 += b6 + XXH3_128.contrib(b7, this.secret[s + 7]);
        }
        int offStripe2 = off + length - 64;
        long b04 = ByteArrayUtil.getLong(input, offStripe2 + 0);
        long b14 = ByteArrayUtil.getLong(input, offStripe2 + 8);
        long b24 = ByteArrayUtil.getLong(input, offStripe2 + 16);
        long b34 = ByteArrayUtil.getLong(input, offStripe2 + 24);
        long b42 = ByteArrayUtil.getLong(input, offStripe2 + 32);
        long b52 = ByteArrayUtil.getLong(input, offStripe2 + 40);
        long b62 = ByteArrayUtil.getLong(input, offStripe2 + 48);
        long b72 = ByteArrayUtil.getLong(input, offStripe2 + 56);
        return this.finalizeHash(length, acc0 += b14 + XXH3_128.contrib(b04, this.secShift16), acc1 += b04 + XXH3_128.contrib(b14, this.secShift17), acc2 += b34 + XXH3_128.contrib(b24, this.secShift18), acc3 += b24 + XXH3_128.contrib(b34, this.secShift19), acc4 += b52 + XXH3_128.contrib(b42, this.secShift20), acc5 += b42 + XXH3_128.contrib(b52, this.secShift21), acc6 += b72 + XXH3_128.contrib(b62, this.secShift22), acc7 += b62 + XXH3_128.contrib(b72, this.secShift23));
    }

    private HashValue128 finalizeHash(long length, long acc0, long acc1, long acc2, long acc3, long acc4, long acc5, long acc6, long acc7) {
        long low = XXH3_128.avalanche3(length * -7046029288634856825L + XXH3_128.mix2Accs(acc0, acc1, this.secShiftFinal0, this.secShiftFinal1) + XXH3_128.mix2Accs(acc2, acc3, this.secShiftFinal2, this.secShiftFinal3) + XXH3_128.mix2Accs(acc4, acc5, this.secShiftFinal4, this.secShiftFinal5) + XXH3_128.mix2Accs(acc6, acc7, this.secShiftFinal6, this.secShiftFinal7));
        long high = XXH3_128.avalanche3((length * -4417276706812531889L ^ 0xFFFFFFFFFFFFFFFFL) + XXH3_128.mix2Accs(acc0, acc1, this.secShiftFinal8, this.secShiftFinal9) + XXH3_128.mix2Accs(acc2, acc3, this.secShiftFinal10, this.secShiftFinal11) + XXH3_128.mix2Accs(acc4, acc5, this.secShiftFinal12, this.secShiftFinal13) + XXH3_128.mix2Accs(acc6, acc7, this.secShiftFinal14, this.secShiftFinal15));
        return new HashValue128(high, low);
    }

    @Override
    public HashValue128 hashCharsTo128Bits(CharSequence charSequence) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int offStripe;
        int s;
        int offBlock;
        int len = charSequence.length();
        if (len <= 8) {
            if (len > 4) {
                long hi = ByteArrayUtil.getLong(charSequence, len - 4);
                long lo = ByteArrayUtil.getLong(charSequence, 0) ^ hi ^ this.bitflip45;
                long m128Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(lo, -7046029288634856825L) + (hi ^= this.bitflip67) + (hi & 0xFFFFFFFFL) * 2246822518L;
                long m128Lo = lo * -7046029288634856825L + ((long)(len << 1) - 1L << 54) ^ Long.reverseBytes(m128Hi);
                long low = XXH3_128.avalanche3(m128Lo * -4417276706812531889L);
                long high = XXH3_128.avalanche3(UnsignedMultiplyUtil.unsignedMultiplyHigh(m128Lo, -4417276706812531889L) + m128Hi * -4417276706812531889L);
                return new HashValue128(high, low);
            }
            if (len >= 2) {
                long lo = (long)ByteArrayUtil.getInt(charSequence, 0) & 0xFFFFFFFFL;
                long hi = ByteArrayUtil.getInt(charSequence, len - 2);
                long keyed = lo + (hi << 32) ^ this.bitflip23;
                long pl = -7046029288634856825L + (long)(len << 3);
                long low = keyed * pl;
                long high = UnsignedMultiplyUtil.unsignedMultiplyHigh(keyed, pl) + (low << 1);
                low ^= high >>> 3;
                low ^= low >>> 35;
                low *= -6939452855193903323L;
                low ^= low >>> 28;
                high = XXH3_128.avalanche3(high);
                return new HashValue128(high, low);
            }
            if (len != 0) {
                char c = charSequence.charAt(0);
                int combinedl = c << 16 | c >>> 8 | 0x200;
                int combinedh = Integer.rotateLeft(Integer.reverseBytes(combinedl), 13);
                long low = XXH3_128.avalanche64((long)combinedl & 0xFFFFFFFFL ^ this.bitflip00);
                long high = XXH3_128.avalanche64((long)combinedh & 0xFFFFFFFFL ^ this.bitflip11);
                return new HashValue128(high, low);
            }
            return this.hash0;
        }
        if (len <= 64) {
            long b32;
            long b22;
            long b12;
            long b02;
            long acc0 = (long)len * -7046029288634856825L << 1;
            long acc1 = 0L;
            if (len > 16) {
                if (len > 32) {
                    if (len > 48) {
                        b02 = ByteArrayUtil.getLong(charSequence, 24);
                        b12 = ByteArrayUtil.getLong(charSequence, 28);
                        b22 = ByteArrayUtil.getLong(charSequence, len - 32);
                        b32 = ByteArrayUtil.getLong(charSequence, len - 28);
                        acc0 = acc0 + XXH3_128.mix2Accs(b02, b12, this.secret12, this.secret13) ^ b22 + b32;
                        acc1 = acc1 + XXH3_128.mix2Accs(b22, b32, this.secret14, this.secret15) ^ b02 + b12;
                    }
                    b02 = ByteArrayUtil.getLong(charSequence, 16);
                    b12 = ByteArrayUtil.getLong(charSequence, 20);
                    b22 = ByteArrayUtil.getLong(charSequence, len - 24);
                    b32 = ByteArrayUtil.getLong(charSequence, len - 20);
                    acc0 = acc0 + XXH3_128.mix2Accs(b02, b12, this.secret08, this.secret09) ^ b22 + b32;
                    acc1 = acc1 + XXH3_128.mix2Accs(b22, b32, this.secret10, this.secret11) ^ b02 + b12;
                }
                b02 = ByteArrayUtil.getLong(charSequence, 8);
                b12 = ByteArrayUtil.getLong(charSequence, 12);
                b22 = ByteArrayUtil.getLong(charSequence, len - 16);
                b32 = ByteArrayUtil.getLong(charSequence, len - 12);
                acc0 = acc0 + XXH3_128.mix2Accs(b02, b12, this.secret04, this.secret05) ^ b22 + b32;
                acc1 = acc1 + XXH3_128.mix2Accs(b22, b32, this.secret06, this.secret07) ^ b02 + b12;
            }
            b02 = ByteArrayUtil.getLong(charSequence, 0);
            b12 = ByteArrayUtil.getLong(charSequence, 4);
            b22 = ByteArrayUtil.getLong(charSequence, len - 8);
            b32 = ByteArrayUtil.getLong(charSequence, len - 4);
            acc0 = acc0 + XXH3_128.mix2Accs(b02, b12, this.secret00, this.secret01) ^ b22 + b32;
            acc1 = acc1 + XXH3_128.mix2Accs(b22, b32, this.secret02, this.secret03) ^ b02 + b12;
            long low = XXH3_128.avalanche3(acc0 + acc1);
            long high = -XXH3_128.avalanche3(acc0 * -7046029288634856825L + acc1 * -8796714831421723037L + ((long)(len << 1) - this.seed) * -4417276706812531889L);
            return new HashValue128(high, low);
        }
        if (len <= 120) {
            long acc0 = (long)len * -7046029288634856825L << 1;
            long acc1 = 0L;
            long b03 = ByteArrayUtil.getLong(charSequence, 0);
            long b13 = ByteArrayUtil.getLong(charSequence, 4);
            long b23 = ByteArrayUtil.getLong(charSequence, 8);
            long b33 = ByteArrayUtil.getLong(charSequence, 12);
            acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secret00, this.secret01) ^ b23 + b33;
            acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secret02, this.secret03) ^ b03 + b13;
            b03 = ByteArrayUtil.getLong(charSequence, 16);
            b13 = ByteArrayUtil.getLong(charSequence, 20);
            b23 = ByteArrayUtil.getLong(charSequence, 24);
            b33 = ByteArrayUtil.getLong(charSequence, 28);
            acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secret04, this.secret05) ^ b23 + b33;
            acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secret06, this.secret07) ^ b03 + b13;
            b03 = ByteArrayUtil.getLong(charSequence, 32);
            b13 = ByteArrayUtil.getLong(charSequence, 36);
            b23 = ByteArrayUtil.getLong(charSequence, 40);
            b33 = ByteArrayUtil.getLong(charSequence, 44);
            acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secret08, this.secret09) ^ b23 + b33;
            acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secret10, this.secret11) ^ b03 + b13;
            b03 = ByteArrayUtil.getLong(charSequence, 48);
            b13 = ByteArrayUtil.getLong(charSequence, 52);
            b23 = ByteArrayUtil.getLong(charSequence, 56);
            b33 = ByteArrayUtil.getLong(charSequence, 60);
            acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secret12, this.secret13) ^ b23 + b33;
            acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secret14, this.secret15) ^ b03 + b13;
            acc0 = XXH3_128.avalanche3(acc0);
            acc1 = XXH3_128.avalanche3(acc1);
            if (80 <= len) {
                b03 = ByteArrayUtil.getLong(charSequence, 64);
                b13 = ByteArrayUtil.getLong(charSequence, 68);
                b23 = ByteArrayUtil.getLong(charSequence, 72);
                b33 = ByteArrayUtil.getLong(charSequence, 76);
                acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secShift00, this.secShift01) ^ b23 + b33;
                acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secShift02, this.secShift03) ^ b03 + b13;
            }
            if (96 <= len) {
                b03 = ByteArrayUtil.getLong(charSequence, 80);
                b13 = ByteArrayUtil.getLong(charSequence, 84);
                b23 = ByteArrayUtil.getLong(charSequence, 88);
                b33 = ByteArrayUtil.getLong(charSequence, 92);
                acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secShift04, this.secShift05) ^ b23 + b33;
                acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secShift06, this.secShift07) ^ b03 + b13;
            }
            if (112 <= len) {
                b03 = ByteArrayUtil.getLong(charSequence, 96);
                b13 = ByteArrayUtil.getLong(charSequence, 100);
                b23 = ByteArrayUtil.getLong(charSequence, 104);
                b33 = ByteArrayUtil.getLong(charSequence, 108);
                acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secShift08, this.secShift09) ^ b23 + b33;
                acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secShift10, this.secShift11) ^ b03 + b13;
            }
            b03 = ByteArrayUtil.getLong(charSequence, len - 8);
            b13 = ByteArrayUtil.getLong(charSequence, len - 4);
            b23 = ByteArrayUtil.getLong(charSequence, len - 16);
            b33 = ByteArrayUtil.getLong(charSequence, len - 12);
            acc0 = acc0 + XXH3_128.mix2Accs(b03, b13, this.secShift12, this.secShift13) ^ b23 + b33;
            acc1 = acc1 + XXH3_128.mix2Accs(b23, b33, this.secShift14, this.secShift15) ^ b03 + b13;
            long low = XXH3_128.avalanche3(acc0 + acc1);
            long high = -XXH3_128.avalanche3(acc0 * -7046029288634856825L + acc1 * -8796714831421723037L + ((long)(len << 1) - this.seed) * -4417276706812531889L);
            return new HashValue128(high, low);
        }
        long acc0 = 3266489917L;
        long acc1 = -7046029288634856825L;
        long acc2 = -4417276706812531889L;
        long acc3 = 1609587929392839161L;
        long acc4 = -8796714831421723037L;
        long acc5 = 2246822519L;
        long acc6 = 2870177450012600261L;
        long acc7 = 2654435761L;
        int nbBlocks = len - 1 >>> 9;
        for (int n = 0; n < nbBlocks; ++n) {
            offBlock = n << 9;
            for (s = 0; s < 16; ++s) {
                offStripe = offBlock + (s << 5);
                b0 = ByteArrayUtil.getLong(charSequence, offStripe + 0);
                b1 = ByteArrayUtil.getLong(charSequence, offStripe + 4);
                b2 = ByteArrayUtil.getLong(charSequence, offStripe + 8);
                b3 = ByteArrayUtil.getLong(charSequence, offStripe + 12);
                b4 = ByteArrayUtil.getLong(charSequence, offStripe + 16);
                b5 = ByteArrayUtil.getLong(charSequence, offStripe + 20);
                b6 = ByteArrayUtil.getLong(charSequence, offStripe + 24);
                b7 = ByteArrayUtil.getLong(charSequence, offStripe + 28);
                acc0 += b1 + XXH3_128.contrib(b0, this.secret[s + 0]);
                acc1 += b0 + XXH3_128.contrib(b1, this.secret[s + 1]);
                acc2 += b3 + XXH3_128.contrib(b2, this.secret[s + 2]);
                acc3 += b2 + XXH3_128.contrib(b3, this.secret[s + 3]);
                acc4 += b5 + XXH3_128.contrib(b4, this.secret[s + 4]);
                acc5 += b4 + XXH3_128.contrib(b5, this.secret[s + 5]);
                acc6 += b7 + XXH3_128.contrib(b6, this.secret[s + 6]);
                acc7 += b6 + XXH3_128.contrib(b7, this.secret[s + 7]);
            }
            acc0 = XXH3_128.mixAcc(acc0, this.secret16);
            acc1 = XXH3_128.mixAcc(acc1, this.secret17);
            acc2 = XXH3_128.mixAcc(acc2, this.secret18);
            acc3 = XXH3_128.mixAcc(acc3, this.secret19);
            acc4 = XXH3_128.mixAcc(acc4, this.secret20);
            acc5 = XXH3_128.mixAcc(acc5, this.secret21);
            acc6 = XXH3_128.mixAcc(acc6, this.secret22);
            acc7 = XXH3_128.mixAcc(acc7, this.secret23);
        }
        int nbStripes = len - 1 - (nbBlocks << 9) >>> 5;
        offBlock = nbBlocks << 9;
        for (s = 0; s < nbStripes; ++s) {
            offStripe = offBlock + (s << 5);
            b0 = ByteArrayUtil.getLong(charSequence, offStripe + 0);
            b1 = ByteArrayUtil.getLong(charSequence, offStripe + 4);
            b2 = ByteArrayUtil.getLong(charSequence, offStripe + 8);
            b3 = ByteArrayUtil.getLong(charSequence, offStripe + 12);
            b4 = ByteArrayUtil.getLong(charSequence, offStripe + 16);
            b5 = ByteArrayUtil.getLong(charSequence, offStripe + 20);
            b6 = ByteArrayUtil.getLong(charSequence, offStripe + 24);
            b7 = ByteArrayUtil.getLong(charSequence, offStripe + 28);
            acc0 += b1 + XXH3_128.contrib(b0, this.secret[s + 0]);
            acc1 += b0 + XXH3_128.contrib(b1, this.secret[s + 1]);
            acc2 += b3 + XXH3_128.contrib(b2, this.secret[s + 2]);
            acc3 += b2 + XXH3_128.contrib(b3, this.secret[s + 3]);
            acc4 += b5 + XXH3_128.contrib(b4, this.secret[s + 4]);
            acc5 += b4 + XXH3_128.contrib(b5, this.secret[s + 5]);
            acc6 += b7 + XXH3_128.contrib(b6, this.secret[s + 6]);
            acc7 += b6 + XXH3_128.contrib(b7, this.secret[s + 7]);
        }
        int offStripe2 = len - 32;
        long b04 = ByteArrayUtil.getLong(charSequence, offStripe2 + 0);
        long b14 = ByteArrayUtil.getLong(charSequence, offStripe2 + 4);
        long b24 = ByteArrayUtil.getLong(charSequence, offStripe2 + 8);
        long b34 = ByteArrayUtil.getLong(charSequence, offStripe2 + 12);
        long b42 = ByteArrayUtil.getLong(charSequence, offStripe2 + 16);
        long b52 = ByteArrayUtil.getLong(charSequence, offStripe2 + 20);
        long b62 = ByteArrayUtil.getLong(charSequence, offStripe2 + 24);
        long b72 = ByteArrayUtil.getLong(charSequence, offStripe2 + 28);
        return this.finalizeHash((long)len << 1, acc0 += b14 + XXH3_128.contrib(b04, this.secShift16), acc1 += b04 + XXH3_128.contrib(b14, this.secShift17), acc2 += b34 + XXH3_128.contrib(b24, this.secShift18), acc3 += b24 + XXH3_128.contrib(b34, this.secShift19), acc4 += b52 + XXH3_128.contrib(b42, this.secShift20), acc5 += b42 + XXH3_128.contrib(b52, this.secShift21), acc6 += b72 + XXH3_128.contrib(b62, this.secShift22), acc7 += b62 + XXH3_128.contrib(b72, this.secShift23));
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        long lo = v1 ^ v2 ^ this.bitflip45;
        long hi = v2 ^ this.bitflip67;
        long m128Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(lo, -7046029288634856825L) + hi + (hi & 0xFFFFFFFFL) * 2246822518L;
        long m128Lo = lo * -7046029288634856825L + 0x3C0000000000000L ^ Long.reverseBytes(m128Hi);
        return XXH3_128.avalanche3(m128Lo * -4417276706812531889L);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        long acc0 = -3084006263850599256L + XXH3_128.mix2Accs(v1, v2, this.secret00, this.secret01) ^ v2 + v3;
        long acc1 = XXH3_128.mix2Accs(v2, v3, this.secret02, this.secret03) ^ v1 + v2;
        return XXH3_128.avalanche3(acc0 + acc1);
    }

    @Override
    protected long finish12Bytes(long a, long b) {
        long lo = b ^ this.bitflip45 ^ a;
        long hi = b ^ this.bitflip67;
        long m128Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(lo, -7046029288634856825L) + hi + (hi & 0xFFFFFFFFL) * 2246822518L;
        long m128Lo = lo * -7046029288634856825L + 0x2C0000000000000L ^ Long.reverseBytes(m128Hi);
        return XXH3_128.avalanche3(m128Lo * -4417276706812531889L);
    }

    private final class HashStreamImpl
    extends XXH3Base.HashStreamImplBase
    implements AbstractHashStream128 {
        private HashStreamImpl() {
        }

        @Override
        public HashValue128 get() {
            if (this.byteCount <= 256L) {
                return XXH3_128.this.hashBytesTo128Bits(this.buffer, 0, (int)this.byteCount);
            }
            ByteArrayUtil.setLong(this.buffer, 256, ByteArrayUtil.getLong(this.buffer, 0));
            long acc0Loc = this.acc0;
            long acc1Loc = this.acc1;
            long acc2Loc = this.acc2;
            long acc3Loc = this.acc3;
            long acc4Loc = this.acc4;
            long acc5Loc = this.acc5;
            long acc6Loc = this.acc6;
            long acc7Loc = this.acc7;
            int off = 0;
            int s = (int)this.byteCount - 1 >>> 6 & 0xC;
            while (off + 64 <= ((int)this.byteCount - 1 & 0xFF)) {
                long b0 = ByteArrayUtil.getLong(this.buffer, off + 0);
                long b1 = ByteArrayUtil.getLong(this.buffer, off + 8);
                long b2 = ByteArrayUtil.getLong(this.buffer, off + 16);
                long b3 = ByteArrayUtil.getLong(this.buffer, off + 24);
                long b4 = ByteArrayUtil.getLong(this.buffer, off + 32);
                long b5 = ByteArrayUtil.getLong(this.buffer, off + 40);
                long b6 = ByteArrayUtil.getLong(this.buffer, off + 48);
                long b7 = ByteArrayUtil.getLong(this.buffer, off + 56);
                acc0Loc += b1 + XXH3Base.contrib(b0, XXH3_128.this.secret[s + 0]);
                acc1Loc += b0 + XXH3Base.contrib(b1, XXH3_128.this.secret[s + 1]);
                acc2Loc += b3 + XXH3Base.contrib(b2, XXH3_128.this.secret[s + 2]);
                acc3Loc += b2 + XXH3Base.contrib(b3, XXH3_128.this.secret[s + 3]);
                acc4Loc += b5 + XXH3Base.contrib(b4, XXH3_128.this.secret[s + 4]);
                acc5Loc += b4 + XXH3Base.contrib(b5, XXH3_128.this.secret[s + 5]);
                acc6Loc += b7 + XXH3Base.contrib(b6, XXH3_128.this.secret[s + 6]);
                acc7Loc += b6 + XXH3Base.contrib(b7, XXH3_128.this.secret[s + 7]);
                off += 64;
                ++s;
            }
            long b0 = ByteArrayUtil.getLong(this.buffer, this.offset - 64 & 0xFF);
            long b1 = ByteArrayUtil.getLong(this.buffer, this.offset - 56 & 0xFF);
            long b2 = ByteArrayUtil.getLong(this.buffer, this.offset - 48 & 0xFF);
            long b3 = ByteArrayUtil.getLong(this.buffer, this.offset - 40 & 0xFF);
            long b4 = ByteArrayUtil.getLong(this.buffer, this.offset - 32 & 0xFF);
            long b5 = ByteArrayUtil.getLong(this.buffer, this.offset - 24 & 0xFF);
            long b6 = ByteArrayUtil.getLong(this.buffer, this.offset - 16 & 0xFF);
            long b7 = ByteArrayUtil.getLong(this.buffer, this.offset - 8 & 0xFF);
            return XXH3_128.this.finalizeHash(this.byteCount, acc0Loc += b1 + XXH3Base.contrib(b0, XXH3_128.this.secShift16), acc1Loc += b0 + XXH3Base.contrib(b1, XXH3_128.this.secShift17), acc2Loc += b3 + XXH3Base.contrib(b2, XXH3_128.this.secShift18), acc3Loc += b2 + XXH3Base.contrib(b3, XXH3_128.this.secShift19), acc4Loc += b5 + XXH3Base.contrib(b4, XXH3_128.this.secShift20), acc5Loc += b4 + XXH3Base.contrib(b5, XXH3_128.this.secShift21), acc6Loc += b7 + XXH3Base.contrib(b6, XXH3_128.this.secShift22), acc7Loc += b6 + XXH3Base.contrib(b7, XXH3_128.this.secShift23));
        }

        @Override
        public HashStream128 putByte(byte v) {
            this.putByteImpl(v);
            return this;
        }

        @Override
        public HashStream128 putShort(short v) {
            this.putShortImpl(v);
            return this;
        }

        @Override
        public HashStream128 putChar(char v) {
            this.putCharImpl(v);
            return this;
        }

        @Override
        public HashStream128 putInt(int v) {
            this.putIntImpl(v);
            return this;
        }

        @Override
        public HashStream128 putLong(long v) {
            this.putLongImpl(v);
            return this;
        }

        @Override
        public HashStream128 putBytes(byte[] b, int off, int len) {
            this.putBytesImpl(b, off, len);
            return this;
        }

        @Override
        public HashStream128 putChars(CharSequence c) {
            this.putCharsImpl(c);
            return this;
        }

        @Override
        public HashStream128 reset() {
            this.resetImpl();
            return this;
        }

        @Override
        public HashStream128 copy() {
            HashStreamImpl hashStream = new HashStreamImpl();
            this.copyImpl(hashStream);
            return hashStream;
        }
    }
}

