/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class Checkpoint {
    public static final String TOPIC_KEY = "topic";
    public static final String PARTITION_KEY = "partition";
    public static final String CONSUMER_GROUP_ID_KEY = "group";
    public static final String UPSTREAM_OFFSET_KEY = "upstreamOffset";
    public static final String DOWNSTREAM_OFFSET_KEY = "offset";
    public static final String METADATA_KEY = "metadata";
    public static final String VERSION_KEY = "version";
    public static final short VERSION = 0;
    public static final Schema VALUE_SCHEMA_V0 = new Schema(new Field[]{new Field("upstreamOffset", (Type)Type.INT64), new Field("offset", (Type)Type.INT64), new Field("metadata", (Type)Type.STRING)});
    public static final Schema KEY_SCHEMA = new Schema(new Field[]{new Field("group", (Type)Type.STRING), new Field("topic", (Type)Type.STRING), new Field("partition", (Type)Type.INT32)});
    public static final Schema HEADER_SCHEMA = new Schema(new Field[]{new Field("version", (Type)Type.INT16)});
    private final String consumerGroupId;
    private final TopicPartition topicPartition;
    private final long upstreamOffset;
    private final long downstreamOffset;
    private final String metadata;

    public Checkpoint(String consumerGroupId, TopicPartition topicPartition, long upstreamOffset, long downstreamOffset, String metadata) {
        this.consumerGroupId = consumerGroupId;
        this.topicPartition = topicPartition;
        this.upstreamOffset = upstreamOffset;
        this.downstreamOffset = downstreamOffset;
        this.metadata = metadata;
    }

    public String consumerGroupId() {
        return this.consumerGroupId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long upstreamOffset() {
        return this.upstreamOffset;
    }

    public long downstreamOffset() {
        return this.downstreamOffset;
    }

    public String metadata() {
        return this.metadata;
    }

    public OffsetAndMetadata offsetAndMetadata() {
        return new OffsetAndMetadata(this.downstreamOffset, this.metadata);
    }

    public String toString() {
        return String.format("Checkpoint{consumerGroupId=%s, topicPartition=%s, upstreamOffset=%d, downstreamOffset=%d, metadata=%s}", this.consumerGroupId, this.topicPartition, this.upstreamOffset, this.downstreamOffset, this.metadata);
    }

    ByteBuffer serializeValue(short version) {
        Struct header = this.headerStruct(version);
        Schema valueSchema = Checkpoint.valueSchema(version);
        Struct valueStruct = this.valueStruct(valueSchema);
        ByteBuffer buffer = ByteBuffer.allocate(HEADER_SCHEMA.sizeOf((Object)header) + valueSchema.sizeOf((Object)valueStruct));
        HEADER_SCHEMA.write(buffer, (Object)header);
        valueSchema.write(buffer, (Object)valueStruct);
        buffer.flip();
        return buffer;
    }

    ByteBuffer serializeKey() {
        Struct struct = this.keyStruct();
        ByteBuffer buffer = ByteBuffer.allocate(KEY_SCHEMA.sizeOf((Object)struct));
        KEY_SCHEMA.write(buffer, (Object)struct);
        buffer.flip();
        return buffer;
    }

    public static Checkpoint deserializeRecord(ConsumerRecord<byte[], byte[]> record) {
        ByteBuffer value = ByteBuffer.wrap((byte[])record.value());
        Struct header = HEADER_SCHEMA.read(value);
        short version = header.getShort(VERSION_KEY);
        Schema valueSchema = Checkpoint.valueSchema(version);
        Struct valueStruct = valueSchema.read(value);
        long upstreamOffset = valueStruct.getLong(UPSTREAM_OFFSET_KEY);
        long downstreamOffset = valueStruct.getLong(DOWNSTREAM_OFFSET_KEY);
        String metadata = valueStruct.getString(METADATA_KEY);
        Struct keyStruct = KEY_SCHEMA.read(ByteBuffer.wrap((byte[])record.key()));
        String group = keyStruct.getString(CONSUMER_GROUP_ID_KEY);
        String topic = keyStruct.getString(TOPIC_KEY);
        int partition = keyStruct.getInt(PARTITION_KEY);
        return new Checkpoint(group, new TopicPartition(topic, partition), upstreamOffset, downstreamOffset, metadata);
    }

    private static Schema valueSchema(short version) {
        assert (version == 0);
        return VALUE_SCHEMA_V0;
    }

    private Struct valueStruct(Schema schema) {
        Struct struct = new Struct(schema);
        struct.set(UPSTREAM_OFFSET_KEY, (Object)this.upstreamOffset);
        struct.set(DOWNSTREAM_OFFSET_KEY, (Object)this.downstreamOffset);
        struct.set(METADATA_KEY, (Object)this.metadata);
        return struct;
    }

    private Struct keyStruct() {
        Struct struct = new Struct(KEY_SCHEMA);
        struct.set(CONSUMER_GROUP_ID_KEY, (Object)this.consumerGroupId);
        struct.set(TOPIC_KEY, (Object)this.topicPartition.topic());
        struct.set(PARTITION_KEY, (Object)this.topicPartition.partition());
        return struct;
    }

    private Struct headerStruct(short version) {
        Struct struct = new Struct(HEADER_SCHEMA);
        struct.set(VERSION_KEY, (Object)version);
        return struct;
    }

    Map<String, ?> connectPartition() {
        HashMap<String, Object> partition = new HashMap<String, Object>();
        partition.put(CONSUMER_GROUP_ID_KEY, this.consumerGroupId);
        partition.put(TOPIC_KEY, this.topicPartition.topic());
        partition.put(PARTITION_KEY, this.topicPartition.partition());
        return partition;
    }

    static String unwrapGroup(Map<String, ?> connectPartition) {
        return connectPartition.get(CONSUMER_GROUP_ID_KEY).toString();
    }

    byte[] recordKey() {
        return this.serializeKey().array();
    }

    byte[] recordValue() {
        return this.serializeValue((short)0).array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checkpoint that = (Checkpoint)o;
        return this.upstreamOffset == that.upstreamOffset && this.downstreamOffset == that.downstreamOffset && Objects.equals(this.consumerGroupId, that.consumerGroupId) && Objects.equals(this.topicPartition, that.topicPartition) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.consumerGroupId, this.topicPartition, this.upstreamOffset, this.downstreamOffset, this.metadata);
    }
}

