/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.http.server;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs3.auxiliary.remote.http.server.AbstractRemoteCacheService;
import org.apache.commons.jcs3.auxiliary.remote.http.server.RemoteHttpCacheServerAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;

public class RemoteHttpCacheService<K, V>
extends AbstractRemoteCacheService<K, V> {
    private static final String EVENT_LOG_SOURCE_NAME = "RemoteHttpCacheServer";
    private final RemoteHttpCacheServerAttributes remoteHttpCacheServerAttributes;

    public RemoteHttpCacheService(ICompositeCacheManager cacheManager, RemoteHttpCacheServerAttributes remoteHttpCacheServerAttributes, ICacheEventLogger cacheEventLogger) {
        super(cacheManager, cacheEventLogger);
        this.setEventLogSourceName(EVENT_LOG_SOURCE_NAME);
        this.remoteHttpCacheServerAttributes = remoteHttpCacheServerAttributes;
    }

    @Override
    public ICacheElement<K, V> processGet(String cacheName, K key, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isAllowClusterGet();
        if (keepLocal) {
            return cache.localGet(key);
        }
        return cache.get(key);
    }

    @Override
    public Map<K, ICacheElement<K, V>> processGetMultiple(String cacheName, Set<K> keys, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isAllowClusterGet();
        if (keepLocal) {
            return cache.localGetMultiple(keys);
        }
        return cache.getMultiple(keys);
    }

    @Override
    public Map<K, ICacheElement<K, V>> processGetMatching(String cacheName, String pattern, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isAllowClusterGet();
        if (keepLocal) {
            return cache.localGetMatching(pattern);
        }
        return cache.getMatching(pattern);
    }

    @Override
    public void processUpdate(ICacheElement<K, V> item, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache<K, V> cache = this.getCacheManager().getCache(item.getCacheName());
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isLocalClusterConsistency();
        if (keepLocal) {
            cache.localUpdate(item);
        } else {
            cache.update(item);
        }
    }

    @Override
    public void processRemove(String cacheName, K key, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isLocalClusterConsistency();
        if (keepLocal) {
            cache.localRemove(key);
        } else {
            cache.remove(key);
        }
    }

    @Override
    public void processRemoveAll(String cacheName, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isLocalClusterConsistency();
        if (keepLocal) {
            cache.localRemoveAll();
        } else {
            cache.removeAll();
        }
    }

    @Override
    public void processDispose(String cacheName, long requesterId) throws IOException {
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        cache.dispose();
    }

    @Override
    public void release() throws IOException {
    }

    @Override
    protected String getExtraInfoForRequesterId(long requesterId) {
        return requesterId + "";
    }
}

