/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.gephi.io.exporter.plugin.NormalizationHelper;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.joda.time.DateTimeZone;

public class ExporterSpreadsheet
implements GraphExporter,
CharacterExporter,
LongTask {
    private boolean exportVisible;
    private ExportTable tableToExport = ExportTable.EDGES;
    private char fieldDelimiter = (char)44;
    private Set<String> excludedColumns = new HashSet<String>();
    private Workspace workspace;
    private Writer writer;
    private boolean cancel = false;
    private ProgressTicket progressTicket;
    private DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
    private DecimalFormat numberFormat = new DecimalFormat("0.######");
    private boolean normalize = false;
    private boolean exportColors = false;
    private boolean exportAttributes = true;
    private boolean exportPosition = false;
    private boolean exportSize = false;
    private boolean exportDynamic = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        GraphModel graphModel = (GraphModel)this.workspace.getLookup().lookup(GraphModel.class);
        Graph graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        Progress.start((ProgressTicket)this.progressTicket);
        graph.readLock();
        try {
            this.exportData(graph);
        }
        catch (Exception e) {
            Logger.getLogger(ExporterSpreadsheet.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            graph.readUnlock();
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        return !this.cancel;
    }

    private void exportData(Graph graph) throws Exception {
        this.decimalFormatSymbols.setInfinity("Infinity");
        this.numberFormat.setDecimalFormatSymbols(this.decimalFormatSymbols);
        NormalizationHelper normalization = NormalizationHelper.build(this.normalize, graph);
        CSVFormat format = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setDelimiter(this.fieldDelimiter).build();
        try (CSVPrinter csvWriter = new CSVPrinter((Appendable)this.writer, format);){
            EdgeIterable rows;
            boolean isEdgeTable = this.tableToExport != ExportTable.NODES;
            Table table = isEdgeTable ? graph.getModel().getEdgeTable() : graph.getModel().getNodeTable();
            Object[] edgeLabels = graph.getModel().getEdgeTypeLabels(false);
            boolean includeEdgeKindColumn = edgeLabels.length > 1;
            TimeFormat timeFormat = graph.getModel().getTimeFormat();
            DateTimeZone timeZone = graph.getModel().getTimeZone();
            Collection columns = this.getExportableColumns(graph.getModel(), table).stream().filter(c -> !this.excludedColumns.contains(c.getId())).collect(Collectors.toCollection(ArrayList::new));
            if (isEdgeTable) {
                csvWriter.print((Object)"Source");
                csvWriter.print((Object)"Target");
                csvWriter.print((Object)"Type");
                if (includeEdgeKindColumn) {
                    csvWriter.print((Object)"Kind");
                }
            }
            for (Column column : columns) {
                String columnTitle;
                String columnId = column.getId();
                String columnHeader = columnId.equalsIgnoreCase(columnTitle = column.getTitle()) ? columnTitle : columnId;
                csvWriter.print((Object)columnHeader);
            }
            if (!isEdgeTable && this.exportPosition) {
                csvWriter.print((Object)"X");
                csvWriter.print((Object)"Y");
                if (normalization.minZ != 0.0f || normalization.maxZ != 0.0f) {
                    csvWriter.print((Object)"Z");
                }
            }
            if (!isEdgeTable && this.exportSize) {
                csvWriter.print((Object)"Size");
            }
            if (this.exportColors) {
                csvWriter.print((Object)"Color");
            }
            csvWriter.println();
            if (isEdgeTable) {
                rows = graph.getEdges();
                Progress.switchToDeterminate((ProgressTicket)this.progressTicket, (int)graph.getEdgeCount());
            } else {
                rows = graph.getNodes();
                Progress.switchToDeterminate((ProgressTicket)this.progressTicket, (int)graph.getNodeCount());
            }
            for (Element row : rows) {
                if (isEdgeTable) {
                    Edge edge = (Edge)row;
                    csvWriter.print(edge.getSource().getId());
                    csvWriter.print(edge.getTarget().getId());
                    csvWriter.print((Object)(edge.isDirected() ? "Directed" : "Undirected"));
                    if (includeEdgeKindColumn) {
                        Object edgeTypeLabel = edge.getTypeLabel();
                        if (edgeTypeLabel != null) {
                            csvWriter.print((Object)edgeTypeLabel.toString());
                        } else {
                            csvWriter.print((Object)"");
                        }
                    }
                }
                for (Column column : columns) {
                    Object value;
                    Object object = value = this.exportDynamic ? row.getAttribute(column) : row.getAttribute(column, graph.getView());
                    String text = value != null ? (value instanceof Number ? this.numberFormat.format(value) : AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone)) : "";
                    csvWriter.print((Object)text);
                }
                if (!isEdgeTable) {
                    Node node = (Node)row;
                    if (this.exportPosition) {
                        float x = normalization.normalizeX(node.x());
                        float y = normalization.normalizeY(node.y());
                        float z = normalization.normalizeZ(node.z());
                        csvWriter.print((Object)this.numberFormat.format(x));
                        csvWriter.print((Object)this.numberFormat.format(y));
                        if (normalization.minZ != 0.0f || normalization.maxZ != 0.0f) {
                            csvWriter.print((Object)this.numberFormat.format(z));
                        }
                    }
                    if (this.exportSize) {
                        float size = normalization.normalizeSize(node.size());
                        csvWriter.print((Object)this.numberFormat.format(size));
                    }
                }
                if (this.exportColors) {
                    csvWriter.print((Object)String.format("#%06x", row.getColor().getRGB() & 0xFFFFFF));
                }
                csvWriter.println();
                Progress.progress((ProgressTicket)this.progressTicket);
                if (!this.cancel) continue;
                rows.doBreak();
                break;
            }
        }
    }

    public Collection<Column> getExportableColumns(GraphModel graphModel, Table table) {
        boolean includeTimeSet = graphModel.isDynamic();
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Column column : table) {
            if (column.getId().equals("timeset") && !includeTimeSet || !this.exportAttributes && !column.isProperty()) continue;
            columns.add(column);
        }
        return columns;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public Set<String> getExcludedColumns() {
        return this.excludedColumns;
    }

    public void setExcludedColumns(Set<String> excludedColumns) {
        this.excludedColumns = excludedColumns;
    }

    public ExportTable getTableToExport() {
        return this.tableToExport;
    }

    public void setTableToExport(ExportTable tableToExport) {
        if (tableToExport == null) {
            throw new NullPointerException("tableToExport must not be null");
        }
        this.tableToExport = tableToExport;
    }

    public void setNumberFormat(DecimalFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public DecimalFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        this.decimalFormatSymbols = decimalFormatSymbols;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.decimalFormatSymbols;
    }

    public void setExportColors(boolean exportColors) {
        this.exportColors = exportColors;
    }

    public boolean isExportColors() {
        return this.exportColors;
    }

    public void setExportPosition(boolean exportPosition) {
        this.exportPosition = exportPosition;
    }

    public boolean isExportPosition() {
        return this.exportPosition;
    }

    public void setExportSize(boolean exportSize) {
        this.exportSize = exportSize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public boolean isExportSize() {
        return this.exportSize;
    }

    public void setExportDynamic(boolean exportDynamic) {
        this.exportDynamic = exportDynamic;
    }

    public boolean isExportDynamic() {
        return this.exportDynamic;
    }

    public void setExportAttributes(boolean exportAttributes) {
        this.exportAttributes = exportAttributes;
    }

    public boolean isExportAttributes() {
        return this.exportAttributes;
    }

    public static enum ExportTable {
        NODES,
        EDGES;

    }
}

