/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.actions.AbstractWorkingSetPulldownDelegate;
import org.eclipse.ui.internal.actions.ConfigureWindowWorkingSetsDialog;

public class SelectWorkingSetsAction
extends AbstractWorkingSetPulldownDelegate {
    @Override
    protected void fillMenu(Menu menu) {
        IWorkingSet[][] typedSets;
        IWorkingSet[][] iWorkingSetArray = typedSets = this.splitSets();
        int n = typedSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet[] sets;
            IWorkingSet[] iWorkingSetArray2 = sets = iWorkingSetArray[n2];
            int n3 = sets.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkingSet set = iWorkingSetArray2[n4];
                ActionContributionItem item = new ActionContributionItem((IAction)new ToggleWorkingSetAction(set));
                item.fill(menu, -1);
                ++n4;
            }
            Separator separator = new Separator();
            separator.fill(menu, -1);
            ++n2;
        }
        ActionContributionItem item = new ActionContributionItem((IAction)new ManageWorkingSetsAction());
        item.fill(menu, -1);
    }

    private IWorkingSet[] getEnabledSets() {
        return this.getWindow().getActivePage().getWorkingSets();
    }

    private boolean isWorkingSetEnabled(IWorkingSet set) {
        IWorkingSet[] enabledSets;
        IWorkingSet[] iWorkingSetArray = enabledSets = this.getEnabledSets();
        int n = enabledSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet enabledSet = iWorkingSetArray[n2];
            if (enabledSet.equals(set)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void run(IAction action) {
        ConfigureWindowWorkingSetsDialog dialog = new ConfigureWindowWorkingSetsDialog(this.getWindow());
        dialog.open();
    }

    private class ManageWorkingSetsAction
    extends Action {
        ManageWorkingSetsAction() {
            super(WorkbenchMessages.Edit);
        }

        public void run() {
            SelectWorkingSetsAction.this.run((IAction)this);
        }
    }

    private class ToggleWorkingSetAction
    extends Action {
        private final IWorkingSet set;

        ToggleWorkingSetAction(IWorkingSet set) {
            super(set.getLabel(), 2);
            this.setImageDescriptor(set.getImageDescriptor());
            this.set = set;
            this.setChecked(SelectWorkingSetsAction.this.isWorkingSetEnabled(set));
        }

        public void runWithEvent(Event event) {
            HashSet<IWorkingSet> newList = new HashSet<IWorkingSet>(Arrays.asList(SelectWorkingSetsAction.this.getWindow().getActivePage().getWorkingSets()));
            if (this.isChecked()) {
                boolean modified;
                boolean bl = modified = (event.stateMask & KeyLookupFactory.getDefault().formalModifierLookup("M1")) != 0;
                if (modified) {
                    newList.clear();
                }
                newList.add(this.set);
            } else {
                newList.remove(this.set);
            }
            SelectWorkingSetsAction.this.getWindow().getActivePage().setWorkingSets(newList.toArray(new IWorkingSet[newList.size()]));
        }
    }
}

