/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.optimize.peephole.WildcardConstantFilter;

public class ConstantPoolEditor {
    private static final boolean DEBUG = false;
    private final ProgramClass targetClass;
    private final ConstantVisitor constantReferenceInitializer;

    public ConstantPoolEditor(ProgramClass targetClass) {
        this(targetClass, null, null);
    }

    public ConstantPoolEditor(ProgramClass targetClass, ClassPool programClassPool, ClassPool libraryClassPool) {
        this.targetClass = targetClass;
        this.constantReferenceInitializer = programClassPool == null ? null : new WildcardConstantFilter(new ClassReferenceInitializer(programClassPool, libraryClassPool));
    }

    public ProgramClass getTargetClass() {
        return this.targetClass;
    }

    public int addIntegerConstant(int value) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            IntegerConstant integerConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 3 || (integerConstant = (IntegerConstant)constant).getValue() != value) continue;
            return index;
        }
        return this.addConstant(new IntegerConstant(value));
    }

    public int addLongConstant(long value) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            LongConstant longConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 5 || (longConstant = (LongConstant)constant).getValue() != value) continue;
            return index;
        }
        return this.addConstant(new LongConstant(value));
    }

    public int addFloatConstant(float value) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            FloatConstant floatConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 4 || (floatConstant = (FloatConstant)constant).getValue() != value) continue;
            return index;
        }
        return this.addConstant(new FloatConstant(value));
    }

    public int addDoubleConstant(double value) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            DoubleConstant doubleConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 6 || (doubleConstant = (DoubleConstant)constant).getValue() != value) continue;
            return index;
        }
        return this.addConstant(new DoubleConstant(value));
    }

    public int addPrimitiveArrayConstant(Object values) {
        return this.addConstant(new PrimitiveArrayConstant(values));
    }

    public int addStringConstant(String string, Clazz referencedClass, Member referencedMember) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 8) continue;
            StringConstant stringConstant = (StringConstant)constant;
            if (stringConstant.u2stringIndex >= constantPoolCount || !stringConstant.getString(this.targetClass).equals(string) || stringConstant.referencedClass != referencedClass || stringConstant.referencedMember != referencedMember) continue;
            return index;
        }
        return this.addConstant(new StringConstant(this.addUtf8Constant(string), referencedClass, referencedMember));
    }

    public int addInvokeDynamicConstant(int bootstrapMethodIndex, String name, String descriptor, Clazz[] referencedClasses) {
        return this.addInvokeDynamicConstant(bootstrapMethodIndex, this.addNameAndTypeConstant(name, descriptor), referencedClasses);
    }

    public int addDynamicConstant(int bootstrapMethodIndex, int nameAndTypeIndex, Clazz[] referencedClasses) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 17) continue;
            DynamicConstant dynamicConstant = (DynamicConstant)constant;
            if (dynamicConstant.u2bootstrapMethodAttributeIndex != bootstrapMethodIndex || dynamicConstant.u2nameAndTypeIndex != nameAndTypeIndex) continue;
            return index;
        }
        return this.addConstant(new DynamicConstant(bootstrapMethodIndex, nameAndTypeIndex, referencedClasses));
    }

    public int addInvokeDynamicConstant(int bootstrapMethodIndex, int nameAndTypeIndex, Clazz[] referencedClasses) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 18) continue;
            InvokeDynamicConstant invokeDynamicConstant = (InvokeDynamicConstant)constant;
            if (invokeDynamicConstant.u2bootstrapMethodAttributeIndex != bootstrapMethodIndex || invokeDynamicConstant.u2nameAndTypeIndex != nameAndTypeIndex) continue;
            return index;
        }
        return this.addConstant(new InvokeDynamicConstant(bootstrapMethodIndex, nameAndTypeIndex, referencedClasses));
    }

    public int addMethodHandleConstant(int referenceKind, int referenceIndex) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 15) continue;
            MethodHandleConstant methodHandleConstant = (MethodHandleConstant)constant;
            if (methodHandleConstant.u1referenceKind != referenceKind || methodHandleConstant.u2referenceIndex != referenceIndex) continue;
            return index;
        }
        return this.addConstant(new MethodHandleConstant(referenceKind, referenceIndex));
    }

    public int addModuleConstant(String name) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            ModuleConstant moduleConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 19 || !(moduleConstant = (ModuleConstant)constant).getName(this.targetClass).equals(name)) continue;
            return index;
        }
        int nameIndex = this.addUtf8Constant(name);
        return this.addConstant(new ModuleConstant(nameIndex));
    }

    public int addPackageConstant(String name) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            PackageConstant packageConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 20 || !(packageConstant = (PackageConstant)constant).getName(this.targetClass).equals(name)) continue;
            return index;
        }
        int nameIndex = this.addUtf8Constant(name);
        return this.addConstant(new PackageConstant(nameIndex));
    }

    public int addFieldrefConstant(Clazz referencedClass, Member referencedMember) {
        return this.addFieldrefConstant(referencedClass.getName(), referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass), referencedClass, referencedMember);
    }

    public int addFieldrefConstant(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addFieldrefConstant(className, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedMember);
    }

    public int addFieldrefConstant(String className, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        return this.addFieldrefConstant(this.addClassConstant(className, referencedClass), nameAndTypeIndex, referencedClass, referencedMember);
    }

    public int addFieldrefConstant(int classIndex, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addFieldrefConstant(classIndex, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedMember);
    }

    public int addFieldrefConstant(int classIndex, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 9) continue;
            FieldrefConstant fieldrefConstant = (FieldrefConstant)constant;
            if (fieldrefConstant.u2classIndex != classIndex || fieldrefConstant.u2nameAndTypeIndex != nameAndTypeIndex) continue;
            return index;
        }
        return this.addConstant(new FieldrefConstant(classIndex, nameAndTypeIndex, referencedClass, referencedMember));
    }

    public int addInterfaceMethodrefConstant(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addInterfaceMethodrefConstant(className, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedMember);
    }

    public int addInterfaceMethodrefConstant(String className, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        return this.addInterfaceMethodrefConstant(this.addClassConstant(className, referencedClass), nameAndTypeIndex, referencedClass, referencedMember);
    }

    public int addInterfaceMethodrefConstant(Clazz referencedClass, Member referencedMember) {
        return this.addInterfaceMethodrefConstant(referencedClass.getName(), referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass), referencedClass, referencedMember);
    }

    public int addInterfaceMethodrefConstant(int classIndex, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addInterfaceMethodrefConstant(classIndex, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedMember);
    }

    public int addInterfaceMethodrefConstant(int classIndex, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 11) continue;
            InterfaceMethodrefConstant methodrefConstant = (InterfaceMethodrefConstant)constant;
            if (methodrefConstant.u2classIndex != classIndex || methodrefConstant.u2nameAndTypeIndex != nameAndTypeIndex) continue;
            return index;
        }
        return this.addConstant(new InterfaceMethodrefConstant(classIndex, nameAndTypeIndex, referencedClass, referencedMember));
    }

    public int addMethodrefConstant(Clazz referencedClass, Member referencedMember) {
        return this.addMethodrefConstant(referencedClass.getName(), referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass), referencedClass, referencedMember);
    }

    public int addMethodrefConstant(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addMethodrefConstant(className, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedMember);
    }

    public int addMethodrefConstant(String className, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        return this.addMethodrefConstant(this.addClassConstant(className, referencedClass), nameAndTypeIndex, referencedClass, referencedMember);
    }

    public int addMethodrefConstant(int classIndex, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addMethodrefConstant(classIndex, this.addNameAndTypeConstant(name, descriptor), referencedClass, referencedMember);
    }

    public int addMethodrefConstant(int classIndex, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 10) continue;
            MethodrefConstant methodrefConstant = (MethodrefConstant)constant;
            if (methodrefConstant.u2classIndex != classIndex || methodrefConstant.u2nameAndTypeIndex != nameAndTypeIndex) continue;
            return index;
        }
        return this.addConstant(new MethodrefConstant(classIndex, nameAndTypeIndex, referencedClass, referencedMember));
    }

    public int addClassConstant(Clazz referencedClass) {
        return this.addClassConstant(referencedClass.getName(), referencedClass);
    }

    public int addClassConstant(String name, Clazz referencedClass) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 7) continue;
            ClassConstant classConstant = (ClassConstant)constant;
            if (classConstant.u2nameIndex >= constantPoolCount || !classConstant.getName(this.targetClass).equals(name)) continue;
            return index;
        }
        int nameIndex = this.addUtf8Constant(name);
        return this.addConstant(new ClassConstant(nameIndex, referencedClass));
    }

    public int addMethodTypeConstant(String type, Clazz[] referencedClasses) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 16) continue;
            MethodTypeConstant methodTypeConstant = (MethodTypeConstant)constant;
            if (methodTypeConstant.u2descriptorIndex >= constantPoolCount || !methodTypeConstant.getType(this.targetClass).equals(type)) continue;
            return index;
        }
        return this.addConstant(new MethodTypeConstant(this.addUtf8Constant(type), referencedClasses));
    }

    public int addNameAndTypeConstant(String name, String type) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 12) continue;
            NameAndTypeConstant nameAndTypeConstant = (NameAndTypeConstant)constant;
            if (nameAndTypeConstant.u2nameIndex >= constantPoolCount || nameAndTypeConstant.u2descriptorIndex >= constantPoolCount || !nameAndTypeConstant.getName(this.targetClass).equals(name) || !nameAndTypeConstant.getType(this.targetClass).equals(type)) continue;
            return index;
        }
        return this.addConstant(new NameAndTypeConstant(this.addUtf8Constant(name), this.addUtf8Constant(type)));
    }

    public int addUtf8Constant(String string) {
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        Constant[] constantPool = this.targetClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Utf8Constant utf8Constant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 1 || !(utf8Constant = (Utf8Constant)constant).getString().equals(string)) continue;
            return index;
        }
        return this.addConstant(new Utf8Constant(string));
    }

    public int addConstant(Constant constant) {
        Constant[] constantPool = this.targetClass.constantPool;
        int constantPoolCount = this.targetClass.u2constantPoolCount;
        if (constantPool.length < constantPoolCount + 2) {
            Constant[] newConstantPool = new Constant[constantPoolCount + 2];
            System.arraycopy(constantPool, 0, newConstantPool, 0, constantPoolCount);
            constantPool = this.targetClass.constantPool = newConstantPool;
        }
        constantPool[this.targetClass.u2constantPoolCount++] = constant;
        int tag = constant.getTag();
        if (tag == 5 || tag == 6) {
            constantPool[this.targetClass.u2constantPoolCount++] = null;
        }
        if (this.constantReferenceInitializer != null) {
            constant.accept(this.targetClass, this.constantReferenceInitializer);
        }
        return constantPoolCount;
    }
}

