/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.catalina.util.TimeBucketCounterBase;

public class TimeBucketCounter
extends TimeBucketCounterBase {
    private final int numBits;
    private final double ratio;

    public TimeBucketCounter(int n, ScheduledExecutorService scheduledExecutorService) {
        super(TimeBucketCounter.getActualDuration(n), scheduledExecutorService);
        this.numBits = TimeBucketCounter.determineShiftBitsOfDuration(n);
        this.ratio = TimeBucketCounter.ratioToPowerOf2(n * 1000);
    }

    @Override
    public long getBucketIndex(long l) {
        return l >> this.numBits;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public int getActualDuration() {
        return (int)Math.pow(2.0, this.getNumBits());
    }

    protected static int determineShiftBitsOfDuration(int n) {
        int n2;
        int n3 = 0;
        int n4 = n2 = TimeBucketCounter.nextPowerOf2(n * 1000);
        while (n4 > 1) {
            n4 = n2 >> ++n3;
        }
        return n3;
    }

    private static int getActualDuration(int n) {
        return (int)(1L << TimeBucketCounter.determineShiftBitsOfDuration(n)) / 1000;
    }

    @Override
    public double getRatio() {
        return this.ratio;
    }

    static double ratioToPowerOf2(int n) {
        double d = TimeBucketCounter.nextPowerOf2(n);
        return (double)Math.round(1000.0 * d / (double)n) / 1000.0;
    }

    static int nextPowerOf2(int n) {
        int n2 = Integer.highestOneBit(n);
        if (n2 == n) {
            return n;
        }
        return n2 << 1;
    }

    @Override
    public long getMillisUntilNextBucket() {
        long l = System.currentTimeMillis();
        long l2 = l + (long)Math.pow(2.0, this.numBits) >> this.numBits << this.numBits;
        return l2 - l;
    }
}

