/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.rescore;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.Rewriteable;
import org.opensearch.search.rescore.RescoreContext;

@PublicApi(since="1.0.0")
public abstract class RescorerBuilder<RB extends RescorerBuilder<RB>>
implements NamedWriteable,
ToXContentObject,
Rewriteable<RescorerBuilder<RB>> {
    public static final int DEFAULT_WINDOW_SIZE = 10;
    protected Integer windowSize;
    private static final ParseField WINDOW_SIZE_FIELD = new ParseField("window_size", new String[0]);

    public RescorerBuilder() {
    }

    protected RescorerBuilder(StreamInput in) throws IOException {
        this.windowSize = in.readOptionalVInt();
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.windowSize);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public RB windowSize(int windowSize) {
        this.windowSize = windowSize;
        return (RB)this;
    }

    public Integer windowSize() {
        return this.windowSize;
    }

    public static RescorerBuilder<?> parseFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        RescorerBuilder rescorer = null;
        Integer windowSize = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (WINDOW_SIZE_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                    windowSize = parser.intValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "rescore doesn't support [" + fieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                rescorer = (RescorerBuilder)parser.namedObject(RescorerBuilder.class, fieldName, null);
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + String.valueOf(token) + "] after [" + fieldName + "]", new Object[0]);
        }
        if (rescorer == null) {
            throw new ParsingException(parser.getTokenLocation(), "missing rescore type", new Object[0]);
        }
        if (windowSize != null) {
            rescorer.windowSize(windowSize);
        }
        return rescorer;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.windowSize != null) {
            builder.field("window_size", this.windowSize);
        }
        this.doXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public final RescoreContext buildContext(QueryShardContext context) throws IOException {
        int finalWindowSize = this.windowSize == null ? 10 : this.windowSize;
        RescoreContext rescoreContext = this.innerBuildContext(finalWindowSize, context);
        return rescoreContext;
    }

    protected abstract RescoreContext innerBuildContext(int var1, QueryShardContext var2) throws IOException;

    public int hashCode() {
        return Objects.hash(this.windowSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RescorerBuilder other = (RescorerBuilder)obj;
        return Objects.equals(this.windowSize, other.windowSize);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this, (boolean)true, (boolean)true);
    }
}

