/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.fir.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.FirParcelizeClassCheckerKt;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.KtErrorsParcelize;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ-\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "parcelizeAnnotations", "", "Lorg/jetbrains/kotlin/name/ClassId;", "<init>", "(Ljava/util/List;)V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)V", "isWriteToParcel", "", "parcelize.k2"})
@SourceDebugExtension(value={"SMAP\nFirParcelizeFunctionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirParcelizeFunctionChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeFunctionChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,40:1\n37#2:41\n*S KotlinDebug\n*F\n+ 1 FirParcelizeFunctionChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeFunctionChecker\n*L\n28#1:41\n*E\n"})
public final class FirParcelizeFunctionChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    private final List<ClassId> parcelizeAnnotations;

    public FirParcelizeFunctionChecker(@NotNull List<ClassId> parcelizeAnnotations) {
        Intrinsics.checkNotNullParameter(parcelizeAnnotations, (String)"parcelizeAnnotations");
        super(MppCheckerKind.Platform);
        this.parcelizeAnnotations = parcelizeAnnotations;
    }

    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirSimpleFunction declaration) {
        FirRegularClassSymbol containingClassSymbol;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        ConeSimpleKotlinType coneSimpleKotlinType = declaration.getDispatchReceiverType();
        FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = coneSimpleKotlinType != null ? ToSymbolUtilsKt.toRegularClassSymbol((ConeKotlinType)((ConeKotlinType)coneSimpleKotlinType), (FirSession)context.getSession()) : null;
        if (!FirParcelizeClassCheckerKt.isParcelize((FirClassSymbol)containingClassSymbol, context.getSession(), this.parcelizeAnnotations)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            return;
        }
        if (this.isWriteToParcel(declaration)) {
            FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)context), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getOVERRIDING_WRITE_TO_PARCEL_IS_NOT_ALLOWED(), null, (int)8, null);
            }
        }
    }

    private final boolean isWriteToParcel(FirSimpleFunction $this$isWriteToParcel) {
        return $this$isWriteToParcel.getTypeParameters().isEmpty() && $this$isWriteToParcel.getValueParameters().size() == 2 && ConeBuiltinTypeUtilsKt.isInt((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)((FirValueParameter)$this$isWriteToParcel.getValueParameters().get(1)).getReturnTypeRef())) && ConeBuiltinTypeUtilsKt.isUnit((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)$this$isWriteToParcel.getReturnTypeRef()));
    }
}

