/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.SessionFactory;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.stat.spi.StatisticsImplementor;

public abstract class AbstractSelectLockingStrategy
implements LockingStrategy {
    private final Lockable lockable;
    private final LockMode lockMode;
    private final String waitForeverSql;
    private String noWaitSql;
    private String skipLockedSql;

    protected AbstractSelectLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        this.waitForeverSql = this.generateLockString(-1);
    }

    protected Lockable getLockable() {
        return this.lockable;
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }

    protected String generateLockString(int lockTimeout) {
        SessionFactoryImplementor factory = this.lockable.getFactory();
        LockOptions lockOptions = new LockOptions(this.lockMode);
        lockOptions.setTimeOut(lockTimeout);
        SimpleSelect select = new SimpleSelect(factory).setLockOptions(lockOptions).setTableName(this.lockable.getRootTableName()).addColumn(this.lockable.getRootTableIdentifierColumnNames()[0]).addRestriction(this.lockable.getRootTableIdentifierColumnNames());
        if (this.lockable.isVersioned()) {
            select.addRestriction(this.lockable.getVersionColumnName());
        }
        if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
            select.setComment(this.lockMode + " lock " + this.lockable.getEntityName());
        }
        return select.toStatementString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Object id, Object version, Object object, int timeout, EventSource session) throws StaleObjectStateException, JDBCException {
        String sql = this.determineSql(timeout);
        SessionFactory factory = session.getFactory();
        Lockable lockable = this.getLockable();
        try {
            JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
            PreparedStatement st = jdbcCoordinator.getStatementPreparer().prepareStatement(sql);
            try {
                lockable.getIdentifierType().nullSafeSet(st, id, 1, session);
                if (lockable.isVersioned()) {
                    lockable.getVersionType().nullSafeSet(st, version, lockable.getIdentifierType().getColumnSpan((Mapping)((Object)factory)) + 1, session);
                }
                ResultSet rs = jdbcCoordinator.getResultSetReturn().extract(st, sql);
                try {
                    if (!rs.next()) {
                        StatisticsImplementor statistics = factory.getStatistics();
                        if (statistics.isStatisticsEnabled()) {
                            statistics.optimisticFailure(lockable.getEntityName());
                        }
                        throw new StaleObjectStateException(lockable.getEntityName(), id);
                    }
                }
                finally {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                }
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw this.convertException(object, this.jdbcException(id, session, sqle, sql));
        }
    }

    private JDBCException jdbcException(Object id, EventSource session, SQLException sqle, String sql) {
        return session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not lock: " + MessageHelper.infoString((EntityPersister)this.lockable, id, (SessionFactoryImplementor)session.getFactory()), sql);
    }

    protected HibernateException convertException(Object entity, JDBCException ex) {
        return ex;
    }

    protected String determineSql(int timeout) {
        switch (timeout) {
            case -1: {
                return this.waitForeverSql;
            }
            case 0: {
                return this.getNoWaitSql();
            }
            case -2: {
                return this.getSkipLockedSql();
            }
        }
        return this.generateLockString(timeout);
    }

    protected String getNoWaitSql() {
        if (this.noWaitSql == null) {
            this.noWaitSql = this.generateLockString(0);
        }
        return this.noWaitSql;
    }

    protected String getSkipLockedSql() {
        if (this.skipLockedSql == null) {
            this.skipLockedSql = this.generateLockString(-2);
        }
        return this.skipLockedSql;
    }
}

