/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ThreadContext;

public class SymbolProc
extends ImmutableLiteral {
    private final RubySymbol name;

    public SymbolProc(RubySymbol name2) {
        this.name = name2;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.SYMBOL_PROC;
    }

    public Object createCacheObject(ThreadContext context) {
        return IRRuntimeHelpers.newSymbolProc(context, this.getName());
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.name.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof SymbolProc && this.name.equals(((SymbolProc)other).name);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SymbolProc(this);
    }

    public String getId() {
        return this.name.idString();
    }

    public RubySymbol getName() {
        return this.name;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.name);
    }

    public static SymbolProc decode(IRReaderDecoder d) {
        return new SymbolProc(d.decodeSymbol());
    }

    public String toString() {
        return "SymbolProc:" + String.valueOf(this.name);
    }

    @Override
    public boolean isTruthyImmediate() {
        return true;
    }
}

