/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JComponent;
import net.infonode.gui.CursorManager;
import net.infonode.gui.SimpleSplitPaneListener;
import net.infonode.gui.panel.BaseContainer;
import net.infonode.gui.panel.SimplePanel;

public class SimpleSplitPane
extends BaseContainer {
    private LayoutManager splitLayout = new LayoutManager(){

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (SimpleSplitPane.this.leftComponent == null || !SimpleSplitPane.this.leftComponent.isVisible()) {
                this.maximize(SimpleSplitPane.this.rightComponent);
            } else if (SimpleSplitPane.this.rightComponent == null || !SimpleSplitPane.this.rightComponent.isVisible()) {
                this.maximize(SimpleSplitPane.this.leftComponent);
            } else {
                float dividerLocation = SimpleSplitPane.this.fixDividerLocation(SimpleSplitPane.this.getDividerLocation());
                int totalSize = SimpleSplitPane.this.getViewSize();
                int leftSize = (int)((float)totalSize * dividerLocation);
                int otherSize = SimpleSplitPane.this.getOtherSize();
                int offsetX = SimpleSplitPane.this.getInsets().left;
                int offsetY = SimpleSplitPane.this.getInsets().top;
                Dimension d = SimpleSplitPane.this.createSize(leftSize, otherSize);
                SimpleSplitPane.this.leftComponent.setBounds(offsetX, offsetY, (int)d.getWidth(), (int)d.getHeight());
                Point p = SimpleSplitPane.this.createPoint(leftSize, 0);
                d = SimpleSplitPane.this.createSize(SimpleSplitPane.this.dividerSize, otherSize);
                SimpleSplitPane.this.dividerPanel.setBounds(p.x + offsetX, p.y + offsetY, (int)d.getWidth(), (int)d.getHeight());
                p = SimpleSplitPane.this.createPoint(leftSize + SimpleSplitPane.this.dividerSize, 0);
                d = SimpleSplitPane.this.createSize(totalSize - leftSize, otherSize);
                SimpleSplitPane.this.rightComponent.setBounds(p.x + offsetX, p.y + offsetY, (int)d.getWidth(), (int)d.getHeight());
            }
        }

        private void maximize(Component component) {
            if (component != null && component.isVisible()) {
                Insets i = SimpleSplitPane.this.getInsets();
                Dimension d = SimpleSplitPane.this.getSize();
                component.setBounds(i.left, i.top, d.width - i.left - i.right, d.height - i.top - i.bottom);
            }
            SimpleSplitPane.this.dividerPanel.setBounds(0, 0, 0, 0);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension d = SimpleSplitPane.this.createSize((SimpleSplitPane.this.leftComponent == null ? 0 : SimpleSplitPane.this.getDimensionSize(SimpleSplitPane.this.leftComponent.getMinimumSize())) + SimpleSplitPane.this.dividerSize + (SimpleSplitPane.this.rightComponent == null ? 0 : SimpleSplitPane.this.getDimensionSize(SimpleSplitPane.this.rightComponent.getMinimumSize())), Math.max(SimpleSplitPane.this.leftComponent == null ? 0 : SimpleSplitPane.this.getOtherSize(SimpleSplitPane.this.leftComponent.getMinimumSize()), SimpleSplitPane.this.rightComponent == null ? 0 : SimpleSplitPane.this.getOtherSize(SimpleSplitPane.this.rightComponent.getMinimumSize())));
            return new Dimension(d.width + SimpleSplitPane.this.getInsets().left + SimpleSplitPane.this.getInsets().right, d.height + SimpleSplitPane.this.getInsets().top + SimpleSplitPane.this.getInsets().bottom);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            boolean lv = SimpleSplitPane.this.leftComponent != null && SimpleSplitPane.this.leftComponent.isVisible();
            boolean rv = SimpleSplitPane.this.rightComponent != null && SimpleSplitPane.this.rightComponent.isVisible();
            Dimension d = SimpleSplitPane.this.createSize((lv ? SimpleSplitPane.this.getDimensionSize(SimpleSplitPane.this.leftComponent.getPreferredSize()) : 0) + (lv && rv ? SimpleSplitPane.this.dividerSize : 0) + (rv ? SimpleSplitPane.this.getDimensionSize(SimpleSplitPane.this.rightComponent.getPreferredSize()) : 0), Math.max(lv ? SimpleSplitPane.this.getOtherSize(SimpleSplitPane.this.leftComponent.getPreferredSize()) : 0, rv ? SimpleSplitPane.this.getOtherSize(SimpleSplitPane.this.rightComponent.getPreferredSize()) : 0));
            return new Dimension(d.width + SimpleSplitPane.this.getInsets().left + SimpleSplitPane.this.getInsets().right, d.height + SimpleSplitPane.this.getInsets().top + SimpleSplitPane.this.getInsets().bottom);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    };
    private Component leftComponent;
    private Component rightComponent;
    private SimplePanel dividerPanel = new SimplePanel();
    private Component dragIndicator;
    private boolean dividerDraggable = true;
    private boolean continuousLayout = true;
    private float dragLocation;
    private boolean horizontal;
    private float dividerLocation = 0.5f;
    private int dividerSize = 6;
    private ArrayList listeners = new ArrayList(0);
    private Color dragIndicatorColor = Color.DARK_GRAY;

    public SimpleSplitPane(boolean horizontal) {
        this(horizontal, false);
    }

    public SimpleSplitPane(boolean horizontal, boolean heavyWeightDragIndicator) {
        this.setLayout(this.splitLayout);
        this.add(this.dividerPanel);
        this.setHorizontal(horizontal);
        this.setHeavyWeightDragIndicator(heavyWeightDragIndicator);
        this.dividerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    CursorManager.setGlobalCursor(SimpleSplitPane.this.getRootPane(), SimpleSplitPane.this.dividerPanel.getCursor());
                    if (SimpleSplitPane.this.dividerDraggable && !SimpleSplitPane.this.continuousLayout) {
                        float location = (float)(SimpleSplitPane.this.getPos(SimpleSplitPane.this.dividerPanel.getLocation()) - SimpleSplitPane.this.getOffset() + SimpleSplitPane.this.getPos(e.getPoint())) / (float)SimpleSplitPane.this.getViewSize();
                        SimpleSplitPane.this.setDragIndicator(location);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    CursorManager.resetGlobalCursor(SimpleSplitPane.this.getRootPane());
                    if (SimpleSplitPane.this.dividerDraggable && !SimpleSplitPane.this.continuousLayout) {
                        SimpleSplitPane.this.dragIndicator.setVisible(false);
                        SimpleSplitPane.this.setDividerLocation(SimpleSplitPane.this.dragLocation);
                    }
                }
            }
        });
        this.dividerPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SimpleSplitPane.this.dividerDraggable && (e.getModifiersEx() & 0x400) != 0) {
                    float location = (float)(SimpleSplitPane.this.getPos(SimpleSplitPane.this.dividerPanel.getLocation()) - SimpleSplitPane.this.getOffset() + SimpleSplitPane.this.getPos(e.getPoint())) / (float)SimpleSplitPane.this.getViewSize();
                    if (SimpleSplitPane.this.continuousLayout) {
                        SimpleSplitPane.this.setDividerLocation(location);
                    } else {
                        SimpleSplitPane.this.setDragIndicator(location);
                    }
                }
            }
        });
    }

    public SimpleSplitPane(boolean horizontal, Component leftComponent, Component rightComponent) {
        this(horizontal);
        this.setLeftComponent(leftComponent);
        this.setRightComponent(rightComponent);
    }

    public void addListener(SimpleSplitPaneListener listener) {
        ArrayList newListeners = new ArrayList(this.listeners.size() + 1);
        newListeners.addAll(this.listeners);
        this.listeners = newListeners;
        this.listeners.add(listener);
    }

    public JComponent getDividerPanel() {
        return this.dividerPanel;
    }

    public boolean isDividerDraggable() {
        return this.dividerDraggable;
    }

    public void setDividerDraggable(boolean dividerDraggable) {
        this.dividerDraggable = dividerDraggable;
        this.updateDividerCursor();
    }

    public void setHeavyWeightDragIndicator(boolean heavyWeight) {
        this.initDragIndicatior(heavyWeight);
    }

    public Color getDragIndicatorColor() {
        return this.dragIndicatorColor;
    }

    public void setDragIndicatorColor(Color dragIndicatorColor) {
        this.dragIndicatorColor = dragIndicatorColor;
        this.dragIndicator.setBackground(dragIndicatorColor);
    }

    private void setDragIndicator(float location) {
        this.dragLocation = this.fixDividerLocation(location);
        this.dragIndicator.setVisible(true);
        Point p = this.createPoint((int)((float)this.getViewSize() * this.dragLocation), 0);
        Dimension d = this.createSize(this.dividerSize, this.getOtherSize());
        this.dragIndicator.setBounds((int)(p.getX() + (double)this.getInsets().left), (int)(p.getY() + (double)this.getInsets().top), (int)d.getWidth(), (int)d.getHeight());
    }

    private void initDragIndicatior(boolean heavyWeight) {
        if (this.dragIndicator != null) {
            this.remove(this.dragIndicator);
        }
        this.dragIndicator = heavyWeight ? new Canvas() : new BaseContainer();
        this.add(this.dragIndicator, 0);
        this.dragIndicator.setBackground(this.dragIndicatorColor);
        this.dragIndicator.setVisible(false);
    }

    private float fixDividerLocation(float location) {
        int totalSize = this.getViewSize();
        if (totalSize <= 0) {
            return 0.5f;
        }
        int leftSize = Math.max((int)((float)totalSize * location), this.leftComponent == null || !this.leftComponent.isVisible() ? 0 : this.getDimensionSize(this.leftComponent.getMinimumSize()));
        leftSize = Math.min(leftSize, totalSize - (this.rightComponent == null || !this.rightComponent.isVisible() ? 0 : this.getDimensionSize(this.rightComponent.getMinimumSize())));
        return (float)leftSize / (float)totalSize;
    }

    public void setContinuousLayout(boolean value) {
        this.continuousLayout = value;
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int dividerSize) {
        this.dividerSize = dividerSize;
        this.revalidate();
    }

    private int getOffset() {
        return this.horizontal ? this.getInsets().left : this.getInsets().top;
    }

    private int getOtherSize() {
        return this.horizontal ? this.getHeight() - this.getInsets().top - this.getInsets().bottom : this.getWidth() - this.getInsets().left - this.getInsets().right;
    }

    private int getViewSize() {
        return this.getDimensionSize(this.getSize()) - this.dividerSize - (this.horizontal ? this.getInsets().left + this.getInsets().right : this.getInsets().top + this.getInsets().bottom);
    }

    private int getDimensionSize(Dimension d) {
        return (int)(this.horizontal ? d.getWidth() : d.getHeight());
    }

    private int getOtherSize(Dimension d) {
        return (int)(this.horizontal ? d.getHeight() : d.getWidth());
    }

    private int getPos(Point p) {
        return (int)(this.horizontal ? p.getX() : p.getY());
    }

    private Dimension createSize(int size, int otherSize) {
        return this.horizontal ? new Dimension(size, otherSize) : new Dimension(otherSize, size);
    }

    private Point createPoint(int pos, int otherPos) {
        return this.horizontal ? new Point(pos, otherPos) : new Point(otherPos, pos);
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        this.updateDividerCursor();
        this.revalidate();
    }

    public float getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(float dividerLocation) {
        this.dividerLocation = dividerLocation;
        this.revalidate();
        int i = 0;
        while (i < this.listeners.size()) {
            ((SimpleSplitPaneListener)this.listeners.get(i)).dividerLocationChanged(this);
            ++i;
        }
    }

    public Component getLeftComponent() {
        return this.leftComponent;
    }

    public void setLeftComponent(Component leftComponent) {
        if (this.leftComponent != null) {
            this.remove(this.leftComponent);
        }
        this.leftComponent = leftComponent;
        if (leftComponent != null) {
            this.add(leftComponent);
        }
        this.revalidate();
    }

    public Component getRightComponent() {
        return this.rightComponent;
    }

    public void setRightComponent(Component rightComponent) {
        if (this.rightComponent != null) {
            this.remove(this.rightComponent);
        }
        this.rightComponent = rightComponent;
        if (rightComponent != null) {
            this.add(rightComponent);
        }
        this.revalidate();
    }

    private void updateDividerCursor() {
        this.dividerPanel.setCursor(this.dividerDraggable ? new Cursor(this.horizontal ? 10 : 8) : Cursor.getDefaultCursor());
    }

    public void setComponents(Component leftComponent, Component rightComponent) {
        this.setLeftComponent(leftComponent);
        this.setRightComponent(rightComponent);
    }
}

