﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sms-voice/PinpointSMSVoice_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace PinpointSMSVoice {
namespace Model {

/**
 * An object that contains information about an event destination that sends data
 * to Amazon CloudWatch Logs.<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/CloudWatchLogsDestination">AWS
 * API Reference</a></p>
 */
class CloudWatchLogsDestination {
 public:
  AWS_PINPOINTSMSVOICE_API CloudWatchLogsDestination() = default;
  AWS_PINPOINTSMSVOICE_API CloudWatchLogsDestination(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINTSMSVOICE_API CloudWatchLogsDestination& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINTSMSVOICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * The Amazon Resource Name (ARN) of an Amazon Identity and Access Management (IAM)
   * role that is able to write event data to an Amazon CloudWatch destination.
   */
  inline const Aws::String& GetIamRoleArn() const { return m_iamRoleArn; }
  inline bool IamRoleArnHasBeenSet() const { return m_iamRoleArnHasBeenSet; }
  template <typename IamRoleArnT = Aws::String>
  void SetIamRoleArn(IamRoleArnT&& value) {
    m_iamRoleArnHasBeenSet = true;
    m_iamRoleArn = std::forward<IamRoleArnT>(value);
  }
  template <typename IamRoleArnT = Aws::String>
  CloudWatchLogsDestination& WithIamRoleArn(IamRoleArnT&& value) {
    SetIamRoleArn(std::forward<IamRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The name of the Amazon CloudWatch Log Group that you want to record events in.
   */
  inline const Aws::String& GetLogGroupArn() const { return m_logGroupArn; }
  inline bool LogGroupArnHasBeenSet() const { return m_logGroupArnHasBeenSet; }
  template <typename LogGroupArnT = Aws::String>
  void SetLogGroupArn(LogGroupArnT&& value) {
    m_logGroupArnHasBeenSet = true;
    m_logGroupArn = std::forward<LogGroupArnT>(value);
  }
  template <typename LogGroupArnT = Aws::String>
  CloudWatchLogsDestination& WithLogGroupArn(LogGroupArnT&& value) {
    SetLogGroupArn(std::forward<LogGroupArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_iamRoleArn;

  Aws::String m_logGroupArn;
  bool m_iamRoleArnHasBeenSet = false;
  bool m_logGroupArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoice
}  // namespace Aws
