/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.datasource;

import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.Stateful;

public abstract class StatefulDataSource
extends DataSource
implements Stateful {
    private int state = -1;
    private int modCount;
    private final Object stateLock = new Object();

    protected StatefulDataSource() {
        this(1);
    }

    protected StatefulDataSource(int state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getModCount() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.modCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setState(final int newState) {
        Object object = this.stateLock;
        synchronized (object) {
            final int oldState = this.state;
            this.state = newState;
            if (oldState != newState && newState == 1) {
                ++this.modCount;
            }
            if (DataSource.EVENT_QUEUE.isRequestProcessorThread()) {
                this.getChangeSupport().firePropertyChange("prop_state", oldState, newState);
            } else {
                DataSource.EVENT_QUEUE.post(new Runnable(){

                    @Override
                    public void run() {
                        StatefulDataSource.this.getChangeSupport().firePropertyChange("prop_state", oldState, newState);
                    }
                });
            }
        }
    }
}

