/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.windows8;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.UIManager;

public class WindowsDPIWorkaroundIcon
implements Icon {
    private final Icon delegate;
    private final int width;
    private final int height;
    private Object restoreUIdefaultsKey;

    public WindowsDPIWorkaroundIcon(Object object, Icon icon) {
        if (object == null || icon == null) {
            throw new NullPointerException();
        }
        this.delegate = icon;
        this.width = icon.getIconWidth();
        this.height = icon.getIconHeight();
        this.restoreUIdefaultsKey = icon.getClass().getName().contains("VistaMenuItemCheckIcon") ? object : null;
    }

    public static boolean isWorkaroundRequired() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String string = UIManager.getLookAndFeel().getClass().getName();
        return string.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") && Boolean.TRUE.equals(toolkit.getDesktopProperty("win.xpstyle.themeActive")) && System.getProperty("swing.noxp") == null;
    }

    private static double roundToNearestMultiple(double d, double d2) {
        return (double)Math.round(d / d2) * d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.restoreUIdefaultsKey != null) {
            UIManager.put(this.restoreUIdefaultsKey, this.delegate);
        }
        try {
            this.paintIconInternal(component, graphics, n, n2);
        }
        finally {
            if (this.restoreUIdefaultsKey != null) {
                UIManager.put(this.restoreUIdefaultsKey, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintIconInternal(Component component, Graphics graphics, int n, int n2) {
        double d = WindowsDPIWorkaroundIcon.getScaling(((Graphics2D)graphics).getTransform());
        double d2 = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0;
        double d3 = this.delegate.getIconWidth();
        double d4 = this.delegate.getIconHeight();
        double d5 = Math.max((d3 - 1.0) / (double)this.width, (d4 - 1.0) / (double)this.height);
        double d6 = Math.min((d3 + 1.0) / (double)this.width, (d4 + 1.0) / (double)this.height);
        double d7 = (d5 + d6) / 2.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(WindowsDPIWorkaroundIcon.roundToNearestMultiple(d / d2, 0.25));
        arrayList.add(d2);
        arrayList.add(1.0 / d2);
        arrayList.add(WindowsDPIWorkaroundIcon.roundToNearestMultiple(d7, 0.25));
        arrayList.add(WindowsDPIWorkaroundIcon.roundToNearestMultiple(1.0 / d7, 0.25));
        double d8 = d7;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            double d9 = (Double)iterator.next();
            if (!(d9 > 0.0) || !(d9 >= d5) || !(d9 <= d6)) continue;
            d8 = d9;
            break;
        }
        double d10 = d8;
        d3 = d10 * d2;
        if (d == d2 && d10 == 1.0) {
            this.delegate.paintIcon(component, graphics, n, n2);
            return;
        }
        Image image = this.createDelegatePaintedImage(component);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            graphics2D.translate(n, n2);
            if (d != 1.0) {
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.setTransform(new AffineTransform(d, 0.0, 0.0, d, (double)((int)affineTransform.getTranslateX()), (double)((int)affineTransform.getTranslateY())));
            }
            WindowsDPIWorkaroundIcon.addScalingRenderingHints(graphics2D);
            graphics2D.scale(1.0 / d3, 1.0 / d3);
            graphics2D.drawImage(image, 0, 0, null);
        }
        finally {
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image createDelegatePaintedImage(Component component) {
        double d = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0;
        BufferedImage bufferedImage = new BufferedImage(2 + (int)Math.ceil((double)this.delegate.getIconWidth() * d), 2 + (int)Math.ceil((double)this.delegate.getIconHeight() * d), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            WindowsDPIWorkaroundIcon.addScalingRenderingHints(graphics2D);
            graphics2D.scale((double)Math.round((double)this.width * d) / (double)this.width, (double)Math.round((double)this.height * d) / (double)this.height);
            this.delegate.paintIcon(component, graphics2D, 0, 0);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    private static void addScalingRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    private static double getScaling(AffineTransform affineTransform) {
        int n = affineTransform.getType();
        if (n == 2 || n == 3) {
            return affineTransform.getScaleX();
        }
        return 1.0;
    }
}

