/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.utility;

import schemacrawler.ermodel.build.TableEntityModelInferrer;
import schemacrawler.ermodel.model.EntityType;
import schemacrawler.ermodel.model.ForeignKeyCardinality;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.OptionalBoolean;

public class EntityModelUtility {
    public static OptionalBoolean coveredByIndex(TableReference fk) {
        if (fk == null) {
            return OptionalBoolean.unknown;
        }
        Table table = fk.getForeignKeyTable();
        if (table == null || MetaDataUtility.isPartial(table)) {
            return OptionalBoolean.unknown;
        }
        TableEntityModelInferrer tableEntityModel = new TableEntityModelInferrer(table);
        OptionalBoolean coveredByIndex = tableEntityModel.foreignKeyCoveredByIndex(fk);
        return coveredByIndex;
    }

    public static OptionalBoolean coveredByUniqueIndex(TableReference fk) {
        if (fk == null) {
            return OptionalBoolean.unknown;
        }
        Table table = fk.getForeignKeyTable();
        if (table == null || MetaDataUtility.isPartial(table)) {
            return OptionalBoolean.unknown;
        }
        TableEntityModelInferrer tableEntityModel = new TableEntityModelInferrer(table);
        OptionalBoolean coveredByIndex = tableEntityModel.foreignKeyCoveredByUniqueIndex(fk);
        return coveredByIndex;
    }

    public static OptionalBoolean inferBridgeTable(Table table) {
        if (table == null || MetaDataUtility.isPartial(table)) {
            return OptionalBoolean.unknown;
        }
        TableEntityModelInferrer tableEntityModel = new TableEntityModelInferrer(table);
        boolean isBridgeTable = tableEntityModel.inferBridgeTable();
        return OptionalBoolean.fromBoolean(isBridgeTable);
    }

    public static ForeignKeyCardinality inferCardinality(TableReference fk) {
        if (fk == null) {
            return ForeignKeyCardinality.unknown;
        }
        Table table = fk.getForeignKeyTable();
        if (table == null || MetaDataUtility.isPartial(table)) {
            return ForeignKeyCardinality.unknown;
        }
        TableEntityModelInferrer tableEntityModel = new TableEntityModelInferrer(table);
        ForeignKeyCardinality fkCardinality = tableEntityModel.inferForeignKeyCardinality(fk);
        return fkCardinality;
    }

    public static EntityType inferEntityType(Table table) {
        if (table == null || MetaDataUtility.isPartial(table)) {
            return EntityType.unknown;
        }
        TableEntityModelInferrer tableEntityModel = new TableEntityModelInferrer(table);
        EntityType entityType = tableEntityModel.inferEntityType();
        return entityType;
    }

    private EntityModelUtility() {
    }
}

