/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.crawl.MutableWeakAssociation;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Index;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableReference;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.TableType;
import schemacrawler.schema.Trigger;
import schemacrawler.schema.WeakAssociation;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.Utility;

class MutableTable
extends AbstractDatabaseObject
implements Table {
    private static final long serialVersionUID = 3257290248802284852L;
    private final NamedObjectList<MutableColumn> columns = new NamedObjectList();
    private final NamedObjectList<TableConstraint> constraints = new NamedObjectList();
    private final NamedObjectList<MutableForeignKey> foreignKeys = new NamedObjectList();
    private final NamedObjectList<MutableWeakAssociation> weakAssociations = new NamedObjectList();
    private final NamedObjectList<MutableColumn> hiddenColumns = new NamedObjectList();
    private final NamedObjectList<MutablePrimaryKey> alternateKeys = new NamedObjectList();
    private final NamedObjectList<MutableIndex> indexes = new NamedObjectList();
    private final NamedObjectList<MutablePrivilege<Table>> privileges = new NamedObjectList();
    private final NamedObjectList<MutableTrigger> triggers = new NamedObjectList();
    private final Set<DatabaseObject> usedByObjects = new HashSet<DatabaseObject>();
    private MutablePrimaryKey primaryKey;
    private int sortIndex;
    private TableType tableType;
    private boolean isSelfReferencing;
    private String definition;

    MutableTable(Schema schema, String name) {
        super(schema, name);
        Utility.requireNotBlank(name, "No table name provided");
        this.definition = "";
        this.tableType = TableType.UNKNOWN;
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        int comparison = 0;
        if (comparison == 0 && obj instanceof MutableTable) {
            MutableTable table = (MutableTable)obj;
            comparison = this.sortIndex - table.sortIndex;
        }
        if (comparison == 0) {
            comparison = super.compareTo(obj);
        }
        return comparison;
    }

    @Override
    public Collection<PrimaryKey> getAlternateKeys() {
        return Set.copyOf(this.alternateKeys.values());
    }

    @Override
    public List<Column> getColumns() {
        return List.copyOf(this.columns.values());
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    public Collection<ForeignKey> getExportedForeignKeys() {
        return this.getTableReferences(this.foreignKeys, TableAssociationType.exported);
    }

    @Override
    public Collection<ForeignKey> getForeignKeys() {
        return this.getTableReferences(this.foreignKeys, TableAssociationType.all);
    }

    @Override
    public Collection<Column> getHiddenColumns() {
        return Set.copyOf(this.hiddenColumns.values());
    }

    @Override
    public Collection<ForeignKey> getImportedForeignKeys() {
        return this.getTableReferences(this.foreignKeys, TableAssociationType.imported);
    }

    @Override
    public Collection<Index> getIndexes() {
        return List.copyOf(this.indexes.values());
    }

    @Override
    public MutablePrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public Collection<Privilege<Table>> getPrivileges() {
        return List.copyOf(this.privileges.values());
    }

    @Override
    public Collection<Table> getRelatedTables(TableRelationshipType tableRelationshipType) {
        HashSet<Table> relatedTables = new HashSet<Table>();
        if (tableRelationshipType != null && tableRelationshipType != TableRelationshipType.none) {
            ArrayList<MutableForeignKey> foreignKeysList = new ArrayList<MutableForeignKey>(this.foreignKeys.values());
            for (ForeignKey foreignKey : foreignKeysList) {
                for (ColumnReference columnReference : foreignKey) {
                    Table parentTable = (Table)columnReference.getPrimaryKeyColumn().getParent();
                    Table childTable = (Table)columnReference.getForeignKeyColumn().getParent();
                    switch (tableRelationshipType) {
                        case parent: {
                            if (!this.equals(childTable)) break;
                            relatedTables.add(parentTable);
                            break;
                        }
                        case child: {
                            if (!this.equals(parentTable)) break;
                            relatedTables.add(childTable);
                            break;
                        }
                    }
                }
            }
        }
        ArrayList<Table> relatedTablesList = new ArrayList<Table>(relatedTables);
        relatedTablesList.sort(NamedObjectSort.alphabetical);
        return relatedTablesList;
    }

    @Override
    public Collection<TableConstraint> getTableConstraints() {
        return List.copyOf(this.constraints.values());
    }

    @Override
    public TableType getTableType() {
        return this.tableType;
    }

    @Override
    public Collection<Trigger> getTriggers() {
        return List.copyOf(this.triggers.values());
    }

    @Override
    public final TableType getType() {
        return this.getTableType();
    }

    @Override
    public Collection<DatabaseObject> getUsedByObjects() {
        return Set.copyOf(this.usedByObjects);
    }

    @Override
    public Collection<WeakAssociation> getWeakAssociations() {
        return this.getTableReferences(this.weakAssociations, TableAssociationType.all);
    }

    @Override
    public final boolean hasDefinition() {
        return !Utility.isBlank(this.definition);
    }

    @Override
    public final boolean hasForeignKeys() {
        return !this.foreignKeys.isEmpty();
    }

    @Override
    public final boolean hasIndexes() {
        return !this.indexes.isEmpty();
    }

    @Override
    public final boolean hasPrimaryKey() {
        return this.getPrimaryKey() != null;
    }

    @Override
    public final boolean hasTriggers() {
        return !this.triggers.isEmpty();
    }

    @Override
    public boolean isSelfReferencing() {
        return this.isSelfReferencing;
    }

    public Optional<MutablePrimaryKey> lookupAlternateKey(String name) {
        return this.alternateKeys.lookup(this, name);
    }

    public Optional<MutableColumn> lookupColumn(String name) {
        Optional<MutableColumn> optionalColumn = this.columns.lookup(this, name);
        if (optionalColumn.isEmpty()) {
            optionalColumn = this.hiddenColumns.lookup(this, name);
        }
        return optionalColumn;
    }

    public Optional<MutableForeignKey> lookupForeignKey(String name) {
        return this.foreignKeys.lookup(this, name);
    }

    public Optional<MutableIndex> lookupIndex(String name) {
        return this.indexes.lookup(this, name);
    }

    public Optional<MutablePrivilege<Table>> lookupPrivilege(String name) {
        return this.privileges.lookup(this, name);
    }

    public Optional<TableConstraint> lookupTableConstraint(String name) {
        return this.constraints.lookup(this, name);
    }

    public Optional<MutableTrigger> lookupTrigger(String triggerName) {
        return this.triggers.lookup(this, triggerName);
    }

    final void addAlternateKey(MutablePrimaryKey alternateKey) {
        this.alternateKeys.add(alternateKey);
    }

    final void addColumn(MutableColumn column) {
        this.columns.add(column);
    }

    final void addForeignKey(MutableForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
    }

    final void addHiddenColumn(MutableColumn column) {
        this.hiddenColumns.add(column);
    }

    final void addIndex(MutableIndex index) {
        this.indexes.add(index);
    }

    final void addPrivilege(MutablePrivilege<Table> privilege) {
        this.privileges.add(privilege);
    }

    final void addReferencingObjects(Collection<DatabaseObject> references) {
        if (references == null || references.isEmpty()) {
            return;
        }
        this.usedByObjects.addAll(references);
    }

    final void addTableConstraint(TableConstraint tableConstraint) {
        this.constraints.add(tableConstraint);
    }

    final void addTrigger(MutableTrigger trigger) {
        this.triggers.add(trigger);
    }

    final void addWeakAssociation(MutableWeakAssociation weakAssociation) {
        this.weakAssociations.add(weakAssociation);
    }

    final NamedObjectList<MutableColumn> getAllColumns() {
        return this.columns;
    }

    final void markAsSelfReferencing() {
        this.isSelfReferencing = true;
    }

    final void removeTableConstraint(TableConstraint tableConstraint) {
        this.constraints.remove(tableConstraint);
    }

    final void setDefinition(String definition) {
        if (!this.hasDefinition() && !Utility.isBlank(definition)) {
            this.definition = definition;
        }
    }

    final void setPrimaryKey(MutablePrimaryKey primaryKey) {
        if (primaryKey != null) {
            this.primaryKey = primaryKey;
        }
    }

    final void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    final void setTableType(TableType tableType) {
        this.tableType = tableType == null ? TableType.UNKNOWN : tableType;
    }

    private <R extends TableReference> Collection<R> getTableReferences(NamedObjectList<? extends R> tableReferences, TableAssociationType tableAssociationType) {
        ArrayList<R> foreignKeysList = new ArrayList<R>(tableReferences.values());
        if (tableAssociationType != null && tableAssociationType != TableAssociationType.all) {
            Iterator iterator = foreignKeysList.iterator();
            while (iterator.hasNext()) {
                TableReference foreignKey = (TableReference)iterator.next();
                boolean isExportedKey = this.equals(foreignKey.getReferencedTable());
                if (tableAssociationType == TableAssociationType.exported && !isExportedKey) {
                    iterator.remove();
                    continue;
                }
                boolean isImportedKey = this.equals(foreignKey.getDependentTable());
                if (tableAssociationType != TableAssociationType.imported || isImportedKey) continue;
                iterator.remove();
            }
        }
        Comparator fkComparator = Comparator.nullsLast(((Comparator)(one, two) -> {
            boolean isTwoImportedKey;
            boolean isOneImportedKey = this.equals(one.getDependentTable());
            if (isOneImportedKey == (isTwoImportedKey = this.equals(two.getDependentTable()))) {
                return 0;
            }
            if (isOneImportedKey) {
                return -1;
            }
            return 1;
        }).thenComparing(Comparator.naturalOrder()));
        Collections.sort(foreignKeysList, fkComparator);
        return foreignKeysList;
    }

    private static enum TableAssociationType {
        all,
        exported,
        imported;

    }
}

