/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;

public class BytecodeFrameInfo
implements FrameInfo {
    @CompilerDirectives.CompilationFinal
    PBytecodeRootNode rootNode;

    void setRootNode(PBytecodeRootNode rootNode) {
        this.rootNode = rootNode;
    }

    @Override
    public PBytecodeRootNode getRootNode() {
        return this.rootNode;
    }

    public int getBci(Frame frame) {
        if (frame.isInt(this.rootNode.bcioffset)) {
            return frame.getInt(this.rootNode.bcioffset);
        }
        return -1;
    }

    public int getLineForBci(int bci) {
        return this.rootNode.bciToLine(bci);
    }

    public int getLine(Frame frame) {
        return this.getLineForBci(this.getBci(frame));
    }

    @Override
    public int getFirstLineNumber() {
        return this.rootNode.getFirstLineno();
    }

    @Override
    public Object getYieldFrom(Frame generatorFrame, int bci, int stackTop) {
        if (bci > 3 && bci < this.rootNode.bytecode.length && this.rootNode.bytecode[bci - 3] == 105 && this.rootNode.bytecode[bci - 1] == 102 && this.rootNode.bytecode[bci] == 104) {
            return generatorFrame.getObject(stackTop);
        }
        return null;
    }

    @Override
    public CodeUnit getCodeUnit() {
        return this.rootNode.getCodeUnit();
    }

    @Override
    public boolean includeInTraceback() {
        return this.rootNode.frameIsVisibleToPython();
    }
}

