/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class GetCatalogs
extends AbstractMetadataMethod {
    private static final RowDescriptor ROW_DESCRIPTOR = DbMetadataMediator.newRowDescriptorBuilder(1).at(0).simple(448, 63, "TABLE_CAT", "TABLECATALOGS").addField().toRowDescriptor();

    private GetCatalogs(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public ResultSet getCatalogs() throws SQLException {
        return this.createEmpty();
    }

    public static GetCatalogs create(DbMetadataMediator mediator) {
        if (mediator.isUseCatalogAsPackage()) {
            return CatalogAsPackage.createInstance(mediator);
        }
        return new GetCatalogs(mediator);
    }

    @Override
    RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        throw new AssertionError((Object)"should not get called");
    }

    private static final class CatalogAsPackage
    extends GetCatalogs {
        private CatalogAsPackage(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetCatalogs createInstance(DbMetadataMediator mediator) {
            return new CatalogAsPackage(mediator);
        }

        @Override
        public ResultSet getCatalogs() throws SQLException {
            DbMetadataMediator.MetadataQuery metadataQuery = new DbMetadataMediator.MetadataQuery("select trim(trailing from RDB$PACKAGE_NAME) as PACKAGE_NAME\nfrom RDB$PACKAGES\norder by RDB$PACKAGE_NAME", List.of());
            return this.createMetaDataResultSet(metadataQuery);
        }

        @Override
        RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
            return valueBuilder.at(0).setString(rs.getString("PACKAGE_NAME")).toRowValue(false);
        }
    }
}

