/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.Objects;
import schemacrawler.ermodel.utility.EntityModelUtility;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintSeverity;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.OptionalBoolean;
import us.fatehi.utility.property.PropertyName;

class LinterForeignKeyWithNoIndexes
extends BaseLinter {
    public LinterForeignKeyWithNoIndexes(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
        this.setSeverity(LintSeverity.low);
    }

    @Override
    public String getSummary() {
        return "foreign key with no index";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        if (MetaDataUtility.isPartial((DatabaseObject)table)) {
            return;
        }
        for (ForeignKey foreignKey : table.getImportedForeignKeys()) {
            if (EntityModelUtility.coveredByIndex((TableReference)foreignKey) != OptionalBoolean.false_value) continue;
            this.addTableLint(table, this.getSummary(), foreignKey);
        }
    }
}

