/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.frame.AccessNameNode;
import com.oracle.graal.python.nodes.frame.WriteGlobalNode;
import com.oracle.graal.python.nodes.frame.WriteNameNodeGen;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(value=false)
public abstract class WriteNameNode
extends PNodeWithContext
implements AccessNameNode {
    public final void execute(VirtualFrame frame, TruffleString attributeId, Object value) {
        CompilerAsserts.partialEvaluationConstant((Object)attributeId);
        this.executeImpl(frame, attributeId, value);
    }

    abstract void executeImpl(VirtualFrame var1, TruffleString var2, Object var3);

    @Specialization(guards={"!hasLocals(frame)"})
    protected static void writeGlobal(VirtualFrame frame, TruffleString attributeId, Object value, @Cached WriteGlobalNode writeGlobal) {
        writeGlobal.executeObject(frame, attributeId, value);
    }

    @Specialization(guards={"hasLocalsDict(frame)"})
    protected static void writeLocalsDict(VirtualFrame frame, TruffleString attributeId, Object value, @Cached(inline=false) HashingCollectionNodes.SetItemNode setItem) {
        PDict frameLocals = (PDict)PArguments.getSpecialArgument((Frame)frame);
        setItem.executeCached((Frame)frame, frameLocals, attributeId, value);
    }

    @Specialization(guards={"hasLocals(frame)"})
    protected static void writeLocal(VirtualFrame frame, TruffleString attributeId, Object value, @Cached(inline=false) PyObjectSetItem setItem) {
        Object frameLocals = PArguments.getSpecialArgument((Frame)frame);
        setItem.executeCached((Frame)frame, frameLocals, attributeId, value);
    }

    @NeverDefault
    public static WriteNameNode create() {
        return WriteNameNodeGen.create();
    }
}

