/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.ComparatorFactory;
import org.assertj.core.data.Index;
import org.assertj.core.data.Offset;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.FloatArrays;
import org.assertj.core.util.CheckReturnValue;

public abstract class AbstractFloatArrayAssert<SELF extends AbstractFloatArrayAssert<SELF>>
extends AbstractArrayAssert<SELF, float[], Float> {
    protected FloatArrays arrays = FloatArrays.instance();

    protected AbstractFloatArrayAssert(float[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (float[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (float[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (float[])this.actual);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (float[])this.actual, expected);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThan(int boundary) {
        this.arrays.assertHasSizeGreaterThan(this.info, (float[])this.actual, boundary);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(this.info, (float[])this.actual, boundary);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThan(int boundary) {
        this.arrays.assertHasSizeLessThan(this.info, (float[])this.actual, boundary);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(this.info, (float[])this.actual, boundary);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeBetween(int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(this.info, (float[])this.actual, lowerBoundary, higherBoundary);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (float[])this.actual, other);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF contains(float ... values) {
        this.arrays.assertContains(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF contains(Float[] values) {
        AbstractFloatArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContains(this.info, (float[])this.actual, AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF contains(float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).contains(values);
    }

    public SELF contains(Float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).contains(AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
    }

    public SELF containsOnly(float ... values) {
        this.arrays.assertContainsOnly(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsOnly(Float[] values) {
        AbstractFloatArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsOnly(this.info, (float[])this.actual, AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsOnly(float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).containsOnly(values);
    }

    public SELF containsOnly(Float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).containsOnly(AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
    }

    public SELF containsOnlyOnce(float ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(Float[] values) {
        AbstractFloatArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsOnlyOnce(this.info, (float[])this.actual, AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).containsOnlyOnce(values);
    }

    public SELF containsOnlyOnce(Float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).containsOnlyOnce(AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
    }

    public SELF containsSequence(float ... sequence2) {
        this.arrays.assertContainsSequence(this.info, (float[])this.actual, sequence2);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsSequence(Float[] sequence2) {
        AbstractFloatArrayAssert.requireNonNullParameter(sequence2, "sequence");
        this.arrays.assertContainsSequence(this.info, (float[])this.actual, AbstractFloatArrayAssert.toPrimitiveFloatArray(sequence2));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsSequence(float[] sequence2, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).containsSequence(sequence2);
    }

    public SELF containsSequence(Float[] sequence2, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).containsSequence(AbstractFloatArrayAssert.toPrimitiveFloatArray(sequence2));
    }

    public SELF containsSubsequence(float ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (float[])this.actual, subsequence);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsSubsequence(Float[] subsequence) {
        AbstractFloatArrayAssert.requireNonNullParameter(subsequence, "subsequence");
        this.arrays.assertContainsSubsequence(this.info, (float[])this.actual, AbstractFloatArrayAssert.toPrimitiveFloatArray(subsequence));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsSubsequence(float[] subsequence, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).containsSubsequence(subsequence);
    }

    public SELF containsSubsequence(Float[] subsequence, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).containsSubsequence(AbstractFloatArrayAssert.toPrimitiveFloatArray(subsequence));
    }

    public SELF contains(float value, Index index) {
        this.arrays.assertContains(this.info, (float[])this.actual, value, index);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF contains(float value, Index index, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).contains(value, index);
    }

    public SELF doesNotContain(float ... values) {
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF doesNotContain(Float[] values) {
        AbstractFloatArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF doesNotContain(float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).doesNotContain(values);
    }

    public SELF doesNotContain(Float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).doesNotContain(AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
    }

    public SELF doesNotContain(float value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, value, index);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF doesNotContain(float value, Index index, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).doesNotContain(value, index);
    }

    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (float[])this.actual);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF doesNotHaveDuplicates(Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).doesNotHaveDuplicates();
    }

    public SELF startsWith(float ... sequence2) {
        this.arrays.assertStartsWith(this.info, (float[])this.actual, sequence2);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF startsWith(Float[] sequence2) {
        AbstractFloatArrayAssert.requireNonNullParameter(sequence2, "sequence");
        this.arrays.assertStartsWith(this.info, (float[])this.actual, AbstractFloatArrayAssert.toPrimitiveFloatArray(sequence2));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF startsWith(float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).startsWith(values);
    }

    public SELF startsWith(Float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).startsWith(AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
    }

    public SELF endsWith(float ... sequence2) {
        this.arrays.assertEndsWith(this.info, (float[])this.actual, sequence2);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF endsWith(Float[] sequence2) {
        AbstractFloatArrayAssert.requireNonNullParameter(sequence2, "sequence");
        this.arrays.assertEndsWith(this.info, (float[])this.actual, AbstractFloatArrayAssert.toPrimitiveFloatArray(sequence2));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF endsWith(float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).endsWith(values);
    }

    public SELF endsWith(Float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).endsWith(AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (float[])this.actual);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super Float> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (float[])this.actual, comparator);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super Float> customComparator) {
        this.arrays = new FloatArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.arrays = FloatArrays.instance();
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsExactly(float ... values) {
        this.arrays.assertContainsExactly(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsExactly(Float[] values) {
        AbstractFloatArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsExactly(this.info, (float[])this.actual, AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsExactly(float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).containsExactly(values);
    }

    public SELF containsExactly(Float[] values, Offset<Float> precision) {
        return ((AbstractFloatArrayAssert)this.usingComparatorWithPrecision((Float)precision.value)).containsExactly(AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
    }

    public SELF containsExactlyInAnyOrder(float ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(Float[] values) {
        AbstractFloatArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (float[])this.actual, AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingComparatorWithPrecision(Float precision) {
        return (SELF)this.usingElementComparator(ComparatorFactory.INSTANCE.floatComparatorWithPrecision(precision.floatValue()));
    }

    public SELF containsAnyOf(float ... values) {
        this.arrays.assertContainsAnyOf(this.info, (float[])this.actual, values);
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    public SELF containsAnyOf(Float[] values) {
        AbstractFloatArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsAnyOf(this.info, (float[])this.actual, AbstractFloatArrayAssert.toPrimitiveFloatArray(values));
        return (SELF)((AbstractFloatArrayAssert)this.myself);
    }

    private static float[] toPrimitiveFloatArray(Float[] values) {
        float[] floats = new float[values.length];
        IntStream.range(0, values.length).forEach(i2 -> {
            floats[i2] = values[i2].floatValue();
        });
        return floats;
    }
}

