/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.BasicXmlTagUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlTagUtil {
    public static String getCDATAQuote(String text) {
        return BasicXmlTagUtil.getCDATAQuote((String)text);
    }

    public static String getInlineQuote(String text) {
        return BasicXmlTagUtil.getInlineQuote((String)text);
    }

    public static CharSequence composeTagText(@NonNls String tagName, @NonNls String tagValue) {
        return BasicXmlTagUtil.composeTagText((String)tagName, (String)tagValue);
    }

    public static String[] getCharacterEntityNames() {
        return BasicXmlTagUtil.getCharacterEntityNames();
    }

    public static char getCharacterByEntityName(String entityName) {
        return BasicXmlTagUtil.getCharacterByEntityName((String)entityName);
    }

    @Nullable
    public static XmlToken getStartTagNameElement(@NotNull XmlTag tag) {
        IElementType elementType;
        ASTNode current;
        ASTNode node;
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(0);
        }
        if ((node = tag.getNode()) == null) {
            return null;
        }
        for (current = node.getFirstChildNode(); current != null && (elementType = current.getElementType()) != XmlTokenType.XML_NAME && elementType != XmlTokenType.XML_TAG_NAME; current = current.getTreeNext()) {
        }
        return current == null ? null : (XmlToken)current.getPsi();
    }

    @Nullable
    public static XmlToken getEndTagNameElement(@NotNull XmlTag tag) {
        ASTNode current;
        ASTNode node;
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(1);
        }
        if ((node = tag.getNode()) == null) {
            return null;
        }
        ASTNode prev = current = node.getLastChildNode();
        while (current != null) {
            IElementType elementType = prev.getElementType();
            if ((elementType == XmlTokenType.XML_NAME || elementType == XmlTokenType.XML_TAG_NAME) && current.getElementType() == XmlTokenType.XML_END_TAG_START) {
                return (XmlToken)prev.getPsi();
            }
            prev = current;
            current = TemplateLanguageUtil.getSameLanguageTreePrev((ASTNode)current);
        }
        return null;
    }

    @NotNull
    public static TextRange getTrimmedValueRange(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(2);
        }
        XmlTagValue tagValue = tag.getValue();
        String text = tagValue.getText();
        String trimmed = text.trim();
        int index = text.indexOf(trimmed);
        int startOffset = tagValue.getTextRange().getStartOffset() - tag.getTextRange().getStartOffset() + index;
        return new TextRange(startOffset, startOffset + trimmed.length());
    }

    @Nullable
    public static TextRange getStartTagRange(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(3);
        }
        XmlToken tagName = XmlTagUtil.getStartTagNameElement(tag);
        return XmlTagUtil.getTagRange(tagName, XmlTokenType.XML_START_TAG_START);
    }

    @Nullable
    public static TextRange getEndTagRange(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(4);
        }
        XmlToken tagName = XmlTagUtil.getEndTagNameElement(tag);
        return XmlTagUtil.getTagRange(tagName, XmlTokenType.XML_END_TAG_START);
    }

    @Nullable
    private static TextRange getTagRange(@Nullable XmlToken tagName, IElementType tagStart) {
        PsiElement f;
        PsiElement s;
        if (tagName == null) {
            return null;
        }
        for (s = tagName.getPrevSibling(); s != null && s.getNode().getElementType() != tagStart; s = s.getPrevSibling()) {
        }
        for (f = tagName.getNextSibling(); f != null && f.getNode().getElementType() != XmlTokenType.XML_TAG_END && f.getNode().getElementType() != XmlTokenType.XML_EMPTY_ELEMENT_END; f = f.getNextSibling()) {
        }
        if (s != null && f != null) {
            return new TextRange(s.getTextRange().getStartOffset(), f.getTextRange().getEndOffset());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "tag";
        objectArray2[1] = "com/intellij/xml/util/XmlTagUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartTagNameElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getEndTagNameElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTrimmedValueRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartTagRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEndTagRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

