/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.protege.editor.owl.model.util.DateFormatter;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class ISO8601Formatter
implements DateFormatter {
    private static final String ISO_8601_UTC_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public ISO8601Formatter() {
        this.df.setTimeZone(UTC);
    }

    @Override
    public OWLLiteral formatDate(Date date, OWLDataFactory dataFactory) {
        String format = this.df.format(date);
        return dataFactory.getOWLLiteral(format, OWL2Datatype.XSD_DATE_TIME);
    }
}

