/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.search.DefaultSearchManager;
import org.protege.editor.owl.model.search.SearchManager;
import org.protege.editor.owl.model.search.SearchManagerPlugin;
import org.protege.editor.owl.model.search.SearchManagerPluginLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchManagerSelector {
    private static final Logger logger = LoggerFactory.getLogger(SearchManagerSelector.class);
    public static final String DEFAULT_PLUGIN_ID = "org.protege.editor.owl.DefaultSearchManager";
    private final ImmutableList<SearchManagerPlugin> plugins;
    private final OWLEditorKit editorKit;
    private SearchManager currentSearchManager;

    public SearchManagerSelector(OWLEditorKit editorKit) {
        this.editorKit = (OWLEditorKit)((Object)Preconditions.checkNotNull((Object)((Object)editorKit)));
        SearchManagerPluginLoader loader = new SearchManagerPluginLoader(editorKit);
        Set plugins = loader.getPlugins();
        this.plugins = ImmutableList.copyOf((Collection)plugins);
    }

    public String getCurrentPluginId() {
        String id = this.getSearchManagerPreferences().getString("search.manager", DEFAULT_PLUGIN_ID);
        if (id.equals(DEFAULT_PLUGIN_ID)) {
            return id;
        }
        for (SearchManagerPlugin plugin : this.plugins) {
            if (!id.equals(plugin.getId())) continue;
            return id;
        }
        return DEFAULT_PLUGIN_ID;
    }

    public void setCurrentPluginId(String id) {
        this.getSearchManagerPreferences().putString("search.manager", (String)Preconditions.checkNotNull((Object)id));
        this.updateCurrentSearchManager();
    }

    private Preferences getSearchManagerPreferences() {
        return PreferencesManager.getInstance().getApplicationPreferences("search.manager.preferences");
    }

    public synchronized SearchManager getCurrentSearchManager() {
        if (this.currentSearchManager == null) {
            this.updateCurrentSearchManager();
        }
        return this.currentSearchManager;
    }

    public Collection<SearchManagerPlugin> getPlugins() {
        return this.plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentSearchManager() {
        try {
            if (this.currentSearchManager != null) {
                this.currentSearchManager.dispose();
                this.currentSearchManager = null;
            }
            String currentPluginId = this.getCurrentPluginId();
            for (SearchManagerPlugin plugin : this.plugins) {
                String pluginId = plugin.getId();
                if (!pluginId.equals(currentPluginId)) continue;
                this.installSearchManager(plugin);
                break;
            }
        }
        catch (Exception e) {
            logger.error("Error initialising selected search manager: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (this.currentSearchManager == null) {
                this.installDefaultSearchManager();
            }
        }
    }

    private void installSearchManager(SearchManagerPlugin plugin) throws Exception {
        SearchManager searchManager = plugin.newInstance();
        searchManager.initialise();
        this.currentSearchManager = searchManager;
    }

    private void installDefaultSearchManager() {
        DefaultSearchManager defaultSearchManager = new DefaultSearchManager();
        defaultSearchManager.setup(this.editorKit);
        defaultSearchManager.initialise();
        this.currentSearchManager = defaultSearchManager;
    }
}

