/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.util.Properties;

public class FipsEntropyConfig {
    private static final int W = 512;
    private static int C;
    private static int AdptC;
    private static float H;
    private static int retry;

    public static float getH() {
        return H;
    }

    public static int getStuckC() {
        return C;
    }

    public static int getAdaptiveProportionateC() {
        return AdptC;
    }

    public static int getAdaptiveProportionateW() {
        return 512;
    }

    public static int getMaxRetries() {
        return retry;
    }

    static {
        Object object;
        String string = Properties.getPropertyValue("org.bouncycastle.entropy.factors");
        if (string != null) {
            object = string.split(",");
            if (((String[])object).length != 3) {
                FipsStatus.moveToErrorStatus(new FipsOperationError("entropy factors needs to be <int>,<int>,<float>"));
            }
            try {
                C = Integer.parseInt(object[0].trim());
                AdptC = Integer.parseInt(object[1].trim());
                H = Float.parseFloat(object[2].trim());
            }
            catch (Exception exception) {
                FipsStatus.moveToErrorStatus(new FipsOperationError("exception parsing entropy factors: " + exception.getMessage(), exception));
            }
        } else {
            C = 4;
            AdptC = 13;
            H = 8.0f;
        }
        if ((object = Properties.getPropertyValue("org.bouncycastle.entropy.retry")) != null) {
            try {
                retry = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                FipsStatus.moveToErrorStatus(new FipsOperationError("exception parsing entropy retry: " + exception.getMessage(), exception));
            }
        } else {
            retry = 5;
        }
    }
}

