/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.runner;

import com.amazon.randomcutforest.CommonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class ArgumentParser {
    public static final String ARCHIVE_NAME = "randomcutforest-core-1.0.jar";
    private final String runnerClass;
    private final String runnerDescription;
    private final Map<String, Argument<?>> shortFlags;
    private final Map<String, Argument<?>> longFlags;
    private final IntegerArgument numberOfTrees;
    private final IntegerArgument sampleSize;
    private final IntegerArgument windowSize;
    private final IntegerArgument shingleSize;
    private final BooleanArgument shingleCyclic;
    private final StringArgument delimiter;
    private final BooleanArgument headerRow;
    private final IntegerArgument randomSeed;

    public ArgumentParser(String runnerClass, String runnerDescription) {
        this.runnerClass = runnerClass;
        this.runnerDescription = runnerDescription;
        this.shortFlags = new HashMap();
        this.longFlags = new HashMap();
        this.numberOfTrees = new IntegerArgument("-n", "--number-of-trees", "Number of trees to use in the forest.", 100, n -> CommonUtils.checkArgument(n > 0, "number of trees should be greater than 0"));
        this.addArgument(this.numberOfTrees);
        this.sampleSize = new IntegerArgument("-s", "--sample-size", "Number of points to keep in sample for each tree.", 256, n -> CommonUtils.checkArgument(n > 0, "sample size should be greater than 0"));
        this.addArgument(this.sampleSize);
        this.windowSize = new IntegerArgument("-w", "--window-size", "Window size of the sample or 0 for no window.", 0, n -> CommonUtils.checkArgument(n > 0, "window size should be greater than 0"));
        this.addArgument(this.windowSize);
        this.shingleSize = new IntegerArgument("-g", "--shingle-size", "Shingle size to use.", 1, n -> CommonUtils.checkArgument(n > 0, "shingle size should be greater than 0"));
        this.addArgument(this.shingleSize);
        this.shingleCyclic = new BooleanArgument("-c", "--shingle-cyclic", "Set to 'true' to use cyclic shingles instead of linear shingles.", false);
        this.addArgument(this.shingleCyclic);
        this.delimiter = new StringArgument("-d", "--delimiter", "The character or string used as a field delimiter.", ",");
        this.addArgument(this.delimiter);
        this.headerRow = new BooleanArgument(null, "--header-row", "Set to 'true' if the data contains a header row.", false);
        this.addArgument(this.headerRow);
        this.randomSeed = new IntegerArgument(null, "--random-seed", "Random seed to use in the Random Cut Forest", 42);
        this.addArgument(this.randomSeed);
    }

    protected void addArgument(Argument<?> argument) {
        CommonUtils.checkNotNull(argument, "argument should not be null");
        CommonUtils.checkArgument(argument.getShortFlag() == null || !this.shortFlags.containsKey(argument.getShortFlag()), String.format("An argument mapping already exists for %s", argument.getShortFlag()));
        CommonUtils.checkArgument(!this.longFlags.containsKey(argument.getLongFlag()), String.format("An argument mapping already exists for %s", argument.getLongFlag()));
        if (argument.getShortFlag() != null) {
            this.shortFlags.put(argument.getShortFlag(), argument);
        }
        this.longFlags.put(argument.getLongFlag(), argument);
    }

    protected void removeArgument(String longFlag) {
        Argument<?> argument = this.longFlags.get(longFlag);
        if (argument != null) {
            this.longFlags.remove(longFlag);
            this.shortFlags.remove(argument.getShortFlag());
        }
    }

    public void parse(String ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            String flag = arguments[i];
            try {
                if (this.shortFlags.containsKey(flag)) {
                    this.shortFlags.get(flag).parse(arguments[++i]);
                    continue;
                }
                if (this.longFlags.containsKey(flag)) {
                    this.longFlags.get(flag).parse(arguments[++i]);
                    continue;
                }
                if ("-h".equals(flag) || "--help".equals(flag)) {
                    this.printUsage();
                    Runtime.getRuntime().exit(0);
                    continue;
                }
                throw new IllegalArgumentException("Unknown argument: " + flag);
            }
            catch (Exception e) {
                this.printUsageAndExit("%s: %s", e.getClass().getName(), e.getMessage());
            }
        }
    }

    public void printUsage() {
        System.out.println(String.format("Usage: java -cp %s %s [options] < input_file > output_file", ARCHIVE_NAME, this.runnerClass));
        System.out.println();
        System.out.println(this.runnerDescription);
        System.out.println();
        System.out.println("Options:");
        this.longFlags.values().stream().map(Argument::getHelpMessage).sorted().forEach(msg -> System.out.println("\t" + msg));
        System.out.println();
        System.out.println("\t--help, -h: Print this help message and exit.");
    }

    public void printUsageAndExit(String errorMessage, Object ... formatObjects) {
        System.err.println("Error: " + String.format(errorMessage, formatObjects));
        this.printUsage();
        System.exit(1);
    }

    public int getNumberOfTrees() {
        return (Integer)this.numberOfTrees.getValue();
    }

    public int getSampleSize() {
        return (Integer)this.sampleSize.getValue();
    }

    public int getWindowSize() {
        return (Integer)this.windowSize.getValue();
    }

    public double getTimeDecay() {
        if (this.getWindowSize() > 0) {
            return 1.0 / (double)this.getWindowSize();
        }
        return 0.0;
    }

    public int getShingleSize() {
        return (Integer)this.shingleSize.getValue();
    }

    public boolean getShingleCyclic() {
        return (Boolean)this.shingleCyclic.getValue();
    }

    public String getDelimiter() {
        return (String)this.delimiter.getValue();
    }

    public boolean getHeaderRow() {
        return (Boolean)this.headerRow.getValue();
    }

    public int getRandomSeed() {
        return (Integer)this.randomSeed.getValue();
    }

    public static class DoubleArgument
    extends Argument<Double> {
        public DoubleArgument(String shortFlag, String longFlag, String description, double defaultValue, Consumer<Double> validateFunction) {
            super(shortFlag, longFlag, description, defaultValue, Double::parseDouble, validateFunction);
        }

        public DoubleArgument(String shortFlag, String longFlag, String description, double defaultValue) {
            super(shortFlag, longFlag, description, defaultValue, Double::parseDouble);
        }
    }

    public static class IntegerArgument
    extends Argument<Integer> {
        public IntegerArgument(String shortFlag, String longFlag, String description, int defaultValue, Consumer<Integer> validateFunction) {
            super(shortFlag, longFlag, description, defaultValue, Integer::parseInt, validateFunction);
        }

        public IntegerArgument(String shortFlag, String longFlag, String description, int defaultValue) {
            super(shortFlag, longFlag, description, defaultValue, Integer::parseInt);
        }
    }

    public static class BooleanArgument
    extends Argument<Boolean> {
        public BooleanArgument(String shortFlag, String longFlag, String description, boolean defaultValue) {
            super(shortFlag, longFlag, description, defaultValue, Boolean::parseBoolean);
        }
    }

    public static class StringArgument
    extends Argument<String> {
        public StringArgument(String shortFlag, String longFlag, String description, String defaultValue, Consumer<String> validateFunction) {
            super(shortFlag, longFlag, description, defaultValue, x -> x, validateFunction);
        }

        public StringArgument(String shortFlag, String longFlag, String description, String defaultValue) {
            super(shortFlag, longFlag, description, defaultValue, (String x) -> x);
        }
    }

    public static class Argument<T> {
        private final String shortFlag;
        private final String longFlag;
        private final String description;
        private final T defaultValue;
        private final Function<String, T> parseFunction;
        private final Consumer<T> validateFunction;
        private T value;

        public Argument(String shortFlag, String longFlag, String description, T defaultValue, Function<String, T> parseFunction, Consumer<T> validateFunction) {
            this.shortFlag = shortFlag;
            this.longFlag = longFlag;
            this.description = description;
            this.defaultValue = defaultValue;
            this.parseFunction = parseFunction;
            this.validateFunction = validateFunction;
            this.value = defaultValue;
        }

        public Argument(String shortFlag, String longFlag, String description, T defaultValue, Function<String, T> parseFunction) {
            this(shortFlag, longFlag, description, defaultValue, parseFunction, t -> {});
        }

        public String getShortFlag() {
            return this.shortFlag;
        }

        public String getLongFlag() {
            return this.longFlag;
        }

        public String getDescription() {
            return this.description;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public String getHelpMessage() {
            if (this.shortFlag != null) {
                return String.format("%s, %s: %s (default: %s)", this.longFlag, this.shortFlag, this.description, this.defaultValue);
            }
            return String.format("%s: %s (default: %s)", this.longFlag, this.description, this.defaultValue);
        }

        public void parse(String string) {
            this.value = this.parseFunction.apply(string);
            this.validateFunction.accept(this.value);
        }

        public T getValue() {
            return this.value;
        }
    }
}

