/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.contentstream.operator.color;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;

public class SetNonStrokingColorSpace
extends OperatorProcessor {
    public SetNonStrokingColorSpace(PDFStreamEngine context) {
        super(context);
    }

    @Override
    public void process(Operator operator, List<COSBase> arguments) throws IOException {
        if (arguments.isEmpty()) {
            return;
        }
        COSBase base = arguments.get(0);
        if (!(base instanceof COSName)) {
            return;
        }
        PDFStreamEngine context = this.getContext();
        if (!context.isShouldProcessColorOperators()) {
            return;
        }
        PDColorSpace cs = context.getResources().getColorSpace((COSName)base);
        context.getGraphicsState().setNonStrokingColorSpace(cs);
        context.getGraphicsState().setNonStrokingColor(cs.getInitialColor());
    }

    @Override
    public String getName() {
        return "cs";
    }
}

