/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Collections;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo8_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("8.0.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo8_0_0.class);

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::migrateRealmCommon);
        session.realms().getRealmsStream().forEach(realm -> this.migrateRealmMFA((RealmModel)realm));
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealmCommon(realm);
    }

    protected void migrateRealmCommon(RealmModel realm) {
        ClientModel accountClient;
        ClientModel adminConsoleClient = realm.getClientByClientId("security-admin-console");
        if (adminConsoleClient != null) {
            adminConsoleClient.setRootUrl("${authAdminUrl}");
            String adminConsoleBaseUrl = "/admin/" + realm.getName() + "/console/";
            adminConsoleClient.setBaseUrl(adminConsoleBaseUrl);
            adminConsoleClient.setRedirectUris(Collections.singleton(adminConsoleBaseUrl + "*"));
            adminConsoleClient.setWebOrigins(Collections.singleton("+"));
        }
        if ((accountClient = realm.getClientByClientId("account")) != null) {
            accountClient.setRootUrl("${authBaseUrl}");
            String accountClientBaseUrl = "/realms/" + realm.getName() + "/account/";
            accountClient.setBaseUrl(accountClientBaseUrl);
            accountClient.setRedirectUris(Collections.singleton(accountClientBaseUrl + "*"));
        }
    }

    protected void migrateRealmMFA(RealmModel realm) {
        realm.getAuthenticationFlowsStream().collect(Collectors.toList()).forEach(authFlow -> realm.getAuthenticationExecutionsStream(authFlow.getId()).filter(exe -> exe.getRequirement() == AuthenticationExecutionModel.Requirement.CONDITIONAL).collect(Collectors.toList()).forEach(exe -> MigrateTo8_0_0.migrateOptionalAuthenticationExecution(realm, authFlow, exe, true)));
    }

    public static void migrateOptionalAuthenticationExecution(RealmModel realm, AuthenticationFlowModel parentFlow, AuthenticationExecutionModel optionalExecution, boolean updateOptionalExecution) {
        LOG.debugf("Migrating optional execution '%s' of flow '%s' of realm '%s' to subflow", (Object)optionalExecution.getAuthenticator(), (Object)parentFlow.getAlias(), (Object)realm.getName());
        AuthenticationFlowModel conditionalOTP = new AuthenticationFlowModel();
        conditionalOTP.setTopLevel(false);
        conditionalOTP.setBuiltIn(parentFlow.isBuiltIn());
        conditionalOTP.setAlias(parentFlow.getAlias() + " - " + optionalExecution.getAuthenticator() + " - Conditional");
        conditionalOTP.setDescription("Flow to determine if the " + optionalExecution.getAuthenticator() + " authenticator should be used or not.");
        conditionalOTP.setProviderId("basic-flow");
        conditionalOTP = realm.addAuthenticationFlow(conditionalOTP);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlow.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.CONDITIONAL);
        execution.setFlowId(conditionalOTP.getId());
        execution.setPriority(optionalExecution.getPriority());
        execution.setAuthenticatorFlow(true);
        realm.addAuthenticatorExecution(execution);
        execution = new AuthenticationExecutionModel();
        execution.setParentFlow(conditionalOTP.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        execution.setAuthenticator("conditional-user-configured");
        execution.setPriority(10);
        execution.setAuthenticatorFlow(false);
        realm.addAuthenticatorExecution(execution);
        optionalExecution.setParentFlow(conditionalOTP.getId());
        optionalExecution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        optionalExecution.setPriority(20);
        if (updateOptionalExecution) {
            realm.updateAuthenticatorExecution(optionalExecution);
        }
    }
}

