/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.ClassBuilder;
import io.github.dmlloyd.classfile.ClassElement;
import io.github.dmlloyd.classfile.FieldBuilder;
import io.github.dmlloyd.classfile.FieldModel;
import io.github.dmlloyd.classfile.FieldTransform;
import io.github.dmlloyd.classfile.MethodBuilder;
import io.github.dmlloyd.classfile.MethodModel;
import io.github.dmlloyd.classfile.MethodTransform;
import io.github.dmlloyd.classfile.constantpool.ConstantPoolBuilder;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.BackportUtil;
import io.github.dmlloyd.classfile.impl.BufferedFieldBuilder;
import io.github.dmlloyd.classfile.impl.BufferedMethodBuilder;
import io.github.dmlloyd.classfile.impl.DirectClassBuilder;
import java.util.Objects;
import java.util.function.Consumer;

public final class ChainedClassBuilder
implements ClassBuilder,
Consumer<ClassElement> {
    private final DirectClassBuilder terminal;
    private final Consumer<ClassElement> consumer;

    public ChainedClassBuilder(ClassBuilder downstream, Consumer<ClassElement> consumer) {
        DirectClassBuilder directClassBuilder;
        this.consumer = consumer;
        if (downstream instanceof ChainedClassBuilder) {
            ChainedClassBuilder cb = (ChainedClassBuilder)downstream;
            directClassBuilder = cb.terminal;
        } else {
            DirectClassBuilder db;
            directClassBuilder = downstream instanceof DirectClassBuilder ? (db = (DirectClassBuilder)downstream) : (DirectClassBuilder)BackportUtil.throwAsObj(IllegalStateException::new);
        }
        this.terminal = directClassBuilder;
    }

    @Override
    public ClassBuilder with(ClassElement element) {
        this.consumer.accept(Objects.requireNonNull(element));
        return this;
    }

    @Override
    public ClassBuilder withField(Utf8Entry name, Utf8Entry descriptor, Consumer<? super FieldBuilder> handler) {
        this.consumer.accept(new BufferedFieldBuilder(this.terminal.constantPool, this.terminal.context, name, descriptor).run(handler).toModel());
        return this;
    }

    @Override
    public ClassBuilder transformField(FieldModel field, FieldTransform transform) {
        BufferedFieldBuilder builder = new BufferedFieldBuilder(this.terminal.constantPool, this.terminal.context, field.fieldName(), field.fieldType());
        builder.transform(field, transform);
        this.consumer.accept(builder.toModel());
        return this;
    }

    @Override
    public ClassBuilder withMethod(Utf8Entry name, Utf8Entry descriptor, int flags, Consumer<? super MethodBuilder> handler) {
        this.consumer.accept(new BufferedMethodBuilder(this.terminal.constantPool, this.terminal.context, name, descriptor, flags, null).run(handler).toModel());
        return this;
    }

    @Override
    public ClassBuilder transformMethod(MethodModel method, MethodTransform transform) {
        BufferedMethodBuilder builder = new BufferedMethodBuilder(this.terminal.constantPool, this.terminal.context, method.methodName(), method.methodType(), method.flags().flagsMask(), method);
        builder.transform(method, transform);
        this.consumer.accept(builder.toModel());
        return this;
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.terminal.constantPool();
    }
}

