/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.block;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.jcs3.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskElementDescriptor;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;
import org.apache.commons.jcs3.utils.struct.AbstractLRUMap;
import org.apache.commons.jcs3.utils.struct.LRUMap;
import org.apache.commons.jcs3.utils.timing.ElapsedTimer;

public class BlockDiskKeyStore<K> {
    private static final Log log = LogManager.getLog(BlockDiskKeyStore.class);
    private final BlockDiskCacheAttributes blockDiskCacheAttributes;
    private Map<K, int[]> keyHash;
    private final File keyFile;
    private static final int KEY_FILE_SIGNATURE = 1784902475;
    protected final String logCacheName;
    private final String fileName;
    private final int maxKeySize;
    protected final BlockDiskCache<K, ?> blockDiskCache;
    private IDiskCacheAttributes.DiskLimitType diskLimitType = IDiskCacheAttributes.DiskLimitType.COUNT;
    private final int blockSize;
    private final IElementSerializer serializer;

    public BlockDiskKeyStore(BlockDiskCacheAttributes cacheAttributes, BlockDiskCache<K, ?> blockDiskCache) {
        this.blockDiskCacheAttributes = cacheAttributes;
        this.logCacheName = "Region [" + this.blockDiskCacheAttributes.getCacheName() + "] ";
        this.fileName = this.blockDiskCacheAttributes.getCacheName();
        this.maxKeySize = cacheAttributes.getMaxKeySize();
        this.blockDiskCache = blockDiskCache;
        this.diskLimitType = cacheAttributes.getDiskLimitType();
        this.blockSize = cacheAttributes.getBlockSizeBytes();
        this.serializer = blockDiskCache == null ? new StandardSerializer() : blockDiskCache.getElementSerializer();
        File rootDirectory = cacheAttributes.getDiskPath();
        log.info("{0}: Cache file root directory [{1}]", this.logCacheName, rootDirectory);
        this.keyFile = new File(rootDirectory, this.fileName + ".key");
        log.info("{0}: Key File [{1}]", this.logCacheName, this.keyFile.getAbsolutePath());
        if (this.keyFile.length() > 0L) {
            this.loadKeys();
            if (!this.verify()) {
                log.warn("{0}: Key File is invalid. Resetting file.", this.logCacheName);
                this.initKeyMap();
                this.reset();
            }
        } else {
            this.initKeyMap();
        }
    }

    protected void clearMemoryMap() {
        this.keyHash.clear();
    }

    public Set<Map.Entry<K, int[]>> entrySet() {
        return this.keyHash.entrySet();
    }

    public int[] get(K key) {
        return this.keyHash.get(key);
    }

    private void initKeyMap() {
        this.keyHash = null;
        if (this.maxKeySize >= 0) {
            this.keyHash = this.diskLimitType == IDiskCacheAttributes.DiskLimitType.SIZE ? new LRUMapSizeLimited(this.maxKeySize) : new LRUMapCountLimited(this.maxKeySize);
            log.info("{0}: Set maxKeySize to: \"{1}\"", this.logCacheName, this.maxKeySize);
        } else {
            this.keyHash = new HashMap<K, int[]>();
            log.info("{0}: Set maxKeySize to unlimited", this.logCacheName);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set<K> keySet() {
        return this.keyHash.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeys() {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> this.logCacheName;
        supplierArray[1] = this.keyFile::toString;
        log.info("{0}: Loading keys for {1}", supplierArray);
        this.initKeyMap();
        HashMap keys = new HashMap();
        File file = this.keyFile;
        synchronized (file) {
            int fileSignature = 0;
            try (FileChannel bc = FileChannel.open(this.keyFile.toPath(), StandardOpenOption.READ);){
                ByteBuffer signature = ByteBuffer.allocate(4);
                bc.read(signature);
                signature.flip();
                fileSignature = signature.getInt();
                if (fileSignature == 1784902475) {
                    try {
                        while (true) {
                            BlockDiskElementDescriptor descriptor;
                            if ((descriptor = (BlockDiskElementDescriptor)this.serializer.deSerializeFrom(bc, null)) == null) {
                                continue;
                            }
                            keys.put(descriptor.getKey(), descriptor.getBlocks());
                        }
                    }
                    catch (EOFException e) {
                        // empty catch block
                    }
                }
            }
            catch (IOException | ClassNotFoundException e) {
                log.error("{0}: Problem loading keys for file {1}", this.logCacheName, this.fileName, e);
            }
            if (fileSignature != 1784902475) {
                try {
                    InputStream fis = Files.newInputStream(this.keyFile.toPath(), new OpenOption[0]);
                    try {
                        ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(fis, null);
                        try {
                            while (true) {
                                BlockDiskElementDescriptor descriptor;
                                if ((descriptor = (BlockDiskElementDescriptor)ois.readObject()) == null) {
                                    continue;
                                }
                                keys.put(descriptor.getKey(), descriptor.getBlocks());
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                ois.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (EOFException fis) {
                }
                catch (IOException | ClassNotFoundException e) {
                    log.error("{0}: Problem loading keys (old style) for file {1}", this.logCacheName, this.fileName, e);
                }
            }
        }
        if (!keys.isEmpty()) {
            this.keyHash.putAll(keys);
            Supplier[] supplierArray2 = new Supplier[2];
            supplierArray2[0] = () -> this.logCacheName;
            supplierArray2[1] = keys::size;
            log.debug("{0}: Found {1} in keys file.", supplierArray2);
            log.info("{0}: Loaded keys from [{1}], key count: {2}; up to {3} will be available.", () -> this.logCacheName, () -> this.fileName, this::size, () -> this.maxKeySize);
        }
    }

    public void put(K key, int[] value) {
        this.keyHash.put(key, value);
    }

    public int[] remove(K key) {
        return this.keyHash.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        File file = this.keyFile;
        synchronized (file) {
            this.clearMemoryMap();
            this.saveKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveKeys() {
        ElapsedTimer timer = new ElapsedTimer();
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> this.logCacheName;
        supplierArray[1] = this.keyFile::getAbsolutePath;
        supplierArray[2] = this::size;
        log.info("{0}: Saving keys to [{1}], key count [{2}]", supplierArray);
        File file = this.keyFile;
        synchronized (file) {
            try (FileChannel bc = FileChannel.open(this.keyFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                if (!this.verify()) {
                    throw new IOException("Inconsistent key file");
                }
                ByteBuffer signature = ByteBuffer.allocate(4);
                signature.putInt(1784902475).flip();
                bc.write(signature);
                for (Map.Entry<K, int[]> entry : this.keyHash.entrySet()) {
                    BlockDiskElementDescriptor<K> descriptor = new BlockDiskElementDescriptor<K>(entry.getKey(), entry.getValue());
                    this.serializer.serializeTo(descriptor, bc);
                }
            }
            catch (IOException e) {
                log.error("{0}: Problem storing keys.", this.logCacheName, e);
            }
        }
        Supplier[] supplierArray2 = new Supplier[4];
        supplierArray2[0] = () -> this.logCacheName;
        supplierArray2[1] = timer::getElapsedTimeString;
        supplierArray2[2] = this::size;
        supplierArray2[3] = this.keyFile::length;
        log.info("{0}: Finished saving keys. It took {1} to store {2} keys. Key file length [{3}]", supplierArray2);
    }

    public int size() {
        return this.keyHash.size();
    }

    private boolean verify() {
        TreeMap<Integer, Set> blockAllocationMap = new TreeMap<Integer, Set>();
        for (Map.Entry<K, int[]> e : this.keyHash.entrySet()) {
            for (int block : e.getValue()) {
                Set keys = blockAllocationMap.computeIfAbsent(block, s -> new HashSet());
                if (!keys.isEmpty() && !log.isTraceEnabled()) {
                    return false;
                }
                keys.add(e.getKey());
            }
        }
        if (!log.isTraceEnabled()) {
            return true;
        }
        boolean ok = true;
        for (Map.Entry e : blockAllocationMap.entrySet()) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = e::getKey;
            supplierArray[1] = e::getValue;
            log.trace("Block {0}: {1}", supplierArray);
            if (((Set)e.getValue()).size() <= 1) continue;
            ok = false;
        }
        return ok;
    }

    public class LRUMapSizeLimited
    extends AbstractLRUMap<K, int[]> {
        public static final String TAG = "orig-lru-size";
        private final AtomicInteger contentSize;
        private final int maxSize;

        public LRUMapSizeLimited() {
            this(-1);
        }

        public LRUMapSizeLimited(int maxSize) {
            this.maxSize = maxSize;
            this.contentSize = new AtomicInteger(0);
        }

        private void addLengthToCacheSize(int[] value) {
            this.contentSize.addAndGet(value.length * BlockDiskKeyStore.this.blockSize / 1024 + 1);
        }

        @Override
        protected void processRemovedLRU(K key, int[] value) {
            BlockDiskKeyStore.this.blockDiskCache.freeBlocks(value);
            if (log.isDebugEnabled()) {
                log.debug("{0}: Removing key: [{1}] from key store.", BlockDiskKeyStore.this.logCacheName, key);
                log.debug("{0}: Key store size: [{1}].", BlockDiskKeyStore.this.logCacheName, super.size());
            }
            if (value != null) {
                this.subLengthFromCacheSize(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] put(K key, int[] value) {
            int[] oldValue = null;
            try {
                oldValue = super.put(key, value);
            }
            finally {
                if (value != null) {
                    this.addLengthToCacheSize(value);
                }
                if (oldValue != null) {
                    this.subLengthFromCacheSize(oldValue);
                }
            }
            return oldValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] remove(Object key) {
            int[] value = null;
            try {
                int[] nArray = value = (int[])super.remove(key);
                return nArray;
            }
            finally {
                if (value != null) {
                    this.subLengthFromCacheSize(value);
                }
            }
        }

        @Override
        protected boolean shouldRemove() {
            return this.maxSize > 0 && this.contentSize.get() > this.maxSize && this.size() > 1;
        }

        private void subLengthFromCacheSize(int[] value) {
            this.contentSize.addAndGet(value.length * BlockDiskKeyStore.this.blockSize / -1024 - 1);
        }
    }

    public class LRUMapCountLimited
    extends LRUMap<K, int[]> {
        public static final String TAG = "orig-lru-count";

        public LRUMapCountLimited(int maxKeySize) {
            super(maxKeySize);
        }

        @Override
        protected void processRemovedLRU(K key, int[] value) {
            BlockDiskKeyStore.this.blockDiskCache.freeBlocks(value);
            if (log.isDebugEnabled()) {
                log.debug("{0}: Removing key: [{1}] from key store.", BlockDiskKeyStore.this.logCacheName, key);
                log.debug("{0}: Key store size: [{1}].", BlockDiskKeyStore.this.logCacheName, super.size());
            }
        }
    }
}

