/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import org.jmol.api.JmolWriter;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.viewer.Viewer;

public class PDBWriter
implements JmolWriter {
    private Viewer vwr;
    private OC oc;
    private boolean isPQR;
    private boolean doTransform;
    private boolean allTrajectories;

    @Override
    public void set(Viewer viewer, OC oc, Object[] data) {
        this.vwr = viewer;
        this.oc = oc == null ? this.vwr.getOutputChannel(null, null) : oc;
        this.isPQR = (Boolean)data[0];
        this.doTransform = (Boolean)data[1];
        this.allTrajectories = (Boolean)data[2];
    }

    @Override
    public String write(BS bs) {
        String type = this.oc.getType();
        this.isPQR |= type != null && type.indexOf("PQR") >= 0;
        this.doTransform |= type != null && type.indexOf("-coord true") >= 0;
        Atom[] atoms = this.vwr.ms.at;
        Model[] models = this.vwr.ms.am;
        String occTemp = "%6.2Q%6.2b          ";
        if (this.isPQR) {
            occTemp = "%8.4P%7.4V       ";
            float charge = 0.0f;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                charge += atoms[i].getPartialCharge();
                i = bs.nextSetBit(i + 1);
            }
            this.oc.append("REMARK   1 PQR file generated by Jmol " + Viewer.getJmolVersion()).append("\nREMARK   1 created " + new Date()).append("\nREMARK   1 Forcefield Used: unknown\nREMARK   1").append("\nREMARK   5").append("\nREMARK   6 Total charge on this protein: " + charge + " e\nREMARK   6\n");
        }
        short iModel = atoms[bs.nextSetBit((int)0)].mi;
        short iModelLast = -1;
        int lastAtomIndex = bs.length() - 1;
        short lastModelIndex = atoms[lastAtomIndex].mi;
        boolean isMultipleModels = iModel != lastModelIndex;
        BS bsModels = this.vwr.ms.getModelBS(bs, true);
        int nModels = bsModels.cardinality();
        Lst<String> lines = new Lst<String>();
        boolean isMultipleBondPDB = models[iModel].isPdbWithMultipleBonds;
        boolean uniqueAtomNumbers = false;
        if (nModels > 1) {
            Object conectArray = null;
            int nFiles = 0;
            int i = bsModels.nextSetBit(0);
            while (i >= 0) {
                Object a = this.vwr.ms.getModelAuxiliaryInfo(i).get("PDB_CONECT_bonds");
                if (a != conectArray || !this.vwr.ms.am[i].isBioModel) {
                    conectArray = a;
                    if (nFiles++ > 0) {
                        uniqueAtomNumbers = true;
                        break;
                    }
                }
                i = bsModels.nextSetBit(i + 1);
            }
        }
        P3 ptTemp = new P3();
        Object[] o = new Object[]{ptTemp};
        Quat q = this.doTransform ? this.vwr.tm.getRotationQ() : null;
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        boolean isBiomodel = false;
        int[] firstAtomIndexNew = uniqueAtomNumbers ? new int[nModels] : null;
        int modelPt = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            Atom a = atoms[i];
            isBiomodel = models[a.mi].isBioModel;
            if (isMultipleModels && a.mi != iModelLast) {
                if (iModelLast != -1) {
                    modelPt = this.fixPDBFormat(lines, map, this.oc, firstAtomIndexNew, modelPt);
                    this.oc.append("ENDMDL\n");
                }
                lines = new Lst();
                iModel = iModelLast = a.mi;
                this.oc.append("MODEL     " + (iModelLast + 1) + "\n");
            }
            String sa = a.getAtomName();
            boolean leftJustify = a.getElementSymbol().length() == 2 || sa.length() >= 4 || PT.isDigit(sa.charAt(0));
            boolean isHetero = a.isHetero();
            LabelToken[] tokens = !isBiomodel ? (leftJustify ? LabelToken.compile(this.vwr, "HETATM%5.-5i %-4.4a%1AUNK %1c   1%1E   _XYZ_" + occTemp, '\u0000', null) : LabelToken.compile(this.vwr, "HETATM%5.-5i  %-3.3a%1AUNK %1c   1%1E   _XYZ_" + occTemp, '\u0000', null)) : (isHetero ? (leftJustify ? LabelToken.compile(this.vwr, "HETATM%5.-5i %-4.4a%1A%3.3n %1c%4.-4R%1E   _XYZ_" + occTemp, '\u0000', null) : LabelToken.compile(this.vwr, "HETATM%5.-5i  %-3.3a%1A%3.3n %1c%4.-4R%1E   _XYZ_" + occTemp, '\u0000', null)) : (leftJustify ? LabelToken.compile(this.vwr, "ATOM  %5.-5i %-4.4a%1A%3.3n %1c%4.-4R%1E   _XYZ_" + occTemp, '\u0000', null) : LabelToken.compile(this.vwr, "ATOM  %5.-5i  %-3.3a%1A%3.3n %1c%4.-4R%1E   _XYZ_" + occTemp, '\u0000', null)));
            String XX = a.getElementSymbolIso(false).toUpperCase();
            XX = this.pdbKey(a.group.getBioPolymerIndexInModel()) + this.pdbKey(a.group.groupIndex) + LabelToken.formatLabelAtomArray(this.vwr, a, tokens, '\u0000', null, ptTemp) + (XX.length() == 1 ? " " + XX : XX.substring(0, 2)) + "  ";
            this.vwr.ms.getPointTransf(-1, a, q, ptTemp);
            String xyz = PT.sprintf("%8.3p%8.3p%8.3p", "p", o);
            if (xyz.length() > 24) {
                xyz = PT.sprintf("%8.2p%8.2p%8.2p", "p", o);
            }
            XX = PT.rep(XX, "_XYZ_", xyz);
            lines.addLast(XX);
            i = bs.nextSetBit(i + 1);
        }
        this.fixPDBFormat(lines, map, this.oc, firstAtomIndexNew, modelPt);
        if (isMultipleModels) {
            this.oc.append("ENDMDL\n");
        }
        modelPt = -1;
        iModelLast = -1;
        String conectKey = "" + (isMultipleModels ? modelPt : 0);
        isBiomodel = false;
        int i2 = bs.nextSetBit(0);
        while (i2 >= 0) {
            Bond[] bonds;
            boolean isCysS;
            Atom a = atoms[i2];
            if (a.mi != iModelLast) {
                Model m = models[a.mi];
                iModelLast = a.mi;
                isBiomodel = m.isBioModel;
                ++modelPt;
            }
            boolean isHetero = !isBiomodel || a.isHetero();
            boolean bl = isCysS = !isHetero && a.getElementNumber() == 16;
            if ((isHetero || isMultipleBondPDB || isCysS) && (bonds = a.bonds) != null) {
                block8: for (int j = 0; j < bonds.length; ++j) {
                    int n;
                    Bond b = bonds[j];
                    int iThis = a.getAtomNumber();
                    Atom a2 = b.getOtherAtom(a);
                    if (!bs.get(a2.i) || (n = b.getCovalentOrder()) == 1 && (isMultipleBondPDB && !isHetero && !isCysS || isCysS && a2.getElementNumber() != 16)) continue;
                    int iOther = a2.getAtomNumber();
                    switch (n) {
                        case 2: 
                        case 3: {
                            if (iOther < iThis) continue block8;
                        }
                        case 1: {
                            Integer inew = (Integer)map.get(conectKey + "." + Integer.valueOf(iThis));
                            Integer inew2 = (Integer)map.get(conectKey + "." + Integer.valueOf(iOther));
                            if (inew == null || inew2 == null) continue block8;
                            this.oc.append("CONECT").append(PT.formatStringS("%5s", "s", "" + inew));
                            String s = PT.formatStringS("%5s", "s", "" + inew2);
                            for (int k = 0; k < n; ++k) {
                                this.oc.append(s);
                            }
                            this.oc.append("\n");
                        }
                    }
                }
            }
            i2 = bs.nextSetBit(i2 + 1);
        }
        return this.toString();
    }

    private String pdbKey(int np) {
        String xp = np < 0 ? "~999" : "   " + np;
        return xp.substring(xp.length() - 4);
    }

    private int fixPDBFormat(Lst<String> lines, Map<String, Integer> map, OC out, int[] firstAtomIndexNew, int modelPt) {
        lines.addLast("~999~999XXXXXX99999999999999999999~99~");
        Object[] alines = new String[lines.size()];
        lines.toArray(alines);
        Arrays.sort(alines);
        lines.clear();
        int n = alines.length;
        for (int i = 0; i < n; ++i) {
            lines.addLast((String)alines[i]);
        }
        String lastPoly = null;
        String lastLine = null;
        int n2 = lines.size();
        int newAtomNumber = 0;
        int iBase = firstAtomIndexNew == null ? 0 : firstAtomIndexNew[modelPt];
        for (int i = 0; i < n2; ++i) {
            boolean isLast;
            String s = (String)lines.get(i);
            String poly = s.substring(0, 4);
            s = s.substring(8);
            boolean isTerm = false;
            boolean bl = isLast = s.indexOf("~99~") >= 0;
            if (!poly.equals(lastPoly) || isLast) {
                if (lastPoly != null && !lastPoly.equals("~999")) {
                    isTerm = true;
                    s = "TER   " + lastLine.substring(6, 11) + "      " + lastLine.substring(17, 27);
                    lines.add(i, poly + "~~~~" + s);
                    ++n2;
                }
                lastPoly = poly;
            }
            if (isLast && !isTerm) break;
            lastLine = s;
            newAtomNumber = i + 1 + iBase;
            if (map != null && !isTerm) {
                map.put("" + modelPt + "." + Integer.valueOf(PT.parseInt(s.substring(6, 11))), newAtomNumber);
            }
            String si = "     " + newAtomNumber;
            out.append(s.substring(0, 6)).append(si.substring(si.length() - 5)).append(s.substring(11)).append("\n");
        }
        if (firstAtomIndexNew != null && ++modelPt < firstAtomIndexNew.length) {
            firstAtomIndexNew[modelPt] = newAtomNumber;
        }
        return modelPt;
    }

    public String toString() {
        return this.oc == null ? "" : this.oc.toString();
    }
}

