/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openscience.jmol.app.janocchio.NMR_Viewer;

public class FrameDeltaDisplay
extends JPanel {
    NMR_Viewer viewer;
    JLabel label;
    JTextField totalfield;
    JTextField coupleWeightField;
    JTextField noeWeightField;
    double coupleWeight = 0.1;
    double noeWeight = 1.0;
    double frameDeltaNoe = 0.0;
    double frameDeltaCouple = 0.0;

    public FrameDeltaDisplay(NMR_Viewer viewer) {
        this.viewer = viewer;
        this.setLayout(new FlowLayout(0));
        this.setMaximumSize(new Dimension(1000, 10));
        this.setVisible(false);
        this.label = new JLabel();
        this.label.setText(this.getLabelText());
        this.totalfield = new JTextField(4);
        this.totalfield.setEditable(false);
        JLabel coupleWeightLabel = new JLabel();
        coupleWeightLabel.setText("Couple Weight");
        JLabel noeWeightLabel = new JLabel();
        noeWeightLabel.setText("NOE Weight");
        this.coupleWeightField = new JTextField(3);
        this.setCoupleWeight(this.coupleWeight);
        this.noeWeightField = new JTextField(3);
        this.setNoeWeight(this.noeWeight);
        this.noeWeightField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String text = FrameDeltaDisplay.this.noeWeightField.getText();
                FrameDeltaDisplay.this.setNoeWeight(Double.parseDouble(text));
            }
        });
        this.coupleWeightField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String text = FrameDeltaDisplay.this.coupleWeightField.getText();
                FrameDeltaDisplay.this.setCoupleWeight(Double.parseDouble(text));
            }
        });
        this.add((Component)this.label, "West");
        this.add((Component)this.totalfield, "East");
        this.add((Component)noeWeightLabel, "East");
        this.add((Component)this.noeWeightField, "East");
        this.add((Component)coupleWeightLabel, "East");
        this.add((Component)this.coupleWeightField, "East");
    }

    public void setFrameDeltaNoe(double frameDelta) {
        this.frameDeltaNoe = frameDelta;
        this.setFieldText();
    }

    public void setFrameDeltaCouple(double frameDelta) {
        this.frameDeltaCouple = frameDelta;
        this.setFieldText();
    }

    private void setFieldText() {
        DecimalFormat df = new DecimalFormat("#0.00");
        double error = this.noeWeight * this.frameDeltaNoe + this.coupleWeight * this.frameDeltaCouple;
        this.totalfield.setText(df.format(error));
    }

    private String getLabelText() {
        String text = "Error:";
        return text;
    }

    private void setNoeWeight(double weight) {
        this.noeWeight = weight;
        DecimalFormat df = new DecimalFormat("#0.0");
        this.noeWeightField.setText(df.format(weight));
        this.setFieldText();
    }

    private void setCoupleWeight(double weight) {
        this.coupleWeight = weight;
        DecimalFormat df = new DecimalFormat("#0.0");
        this.coupleWeightField.setText(df.format(weight));
        this.setFieldText();
    }

    public double getNoeWeight() {
        return this.noeWeight;
    }

    public double getCoupleWeight() {
        return this.coupleWeight;
    }
}

