---
stage: Fulfillment
group: Utilization
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ストレージ
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com

{{< /details >}}

## Freeプランの制限 {#free-limit}

{{< details >}}

- プラン: Free

{{< /details >}}

GitLab.comのFreeプランのネームスペースにある各プロジェクトのGitリポジトリとLarge File Storage（LFS）には、10 GiBの無料ストレージが割り当てられています。

プロジェクトのリポジトリとLFSが10 GiBを超えると、プロジェクトは読み取り専用状態に設定されます。読み取り専用プロジェクトに変更をプッシュすることはできません。プロジェクトのリポジトリとLFSのストレージを10 GiBより大きくするには、ストレージを追加購入する必要があります。

ストレージ制限が適用されるのは、プロジェクトのリポジトリとLFSのみです。この制限は、コンテナレジストリ、パッケージレジストリ、ビルドアーティファクトには適用されません。

## ストレージを表示する {#view-storage}

{{< details >}}

- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

プロジェクトおよびネームスペースのストレージ使用量について、以下の統計を表示できます。

- GitLab.comのストレージ制限または[GitLab Self-Managedのストレージ制限](../administration/settings/account_and_limit_settings.md#repository-size-limit)を超えるストレージ使用量。
- GitLab.comで利用可能な購入済みストレージ。

前提要件:

- プロジェクトのストレージ使用量を表示するには、少なくともプロジェクトのメンテナーロールまたはネームスペースのオーナーロールが必要です。
- グループネームスペースのストレージ使用量を表示するには、ネームスペースのオーナーロールが必要です。

ストレージを表示するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **設定 > 使用量クォータ**を選択します。
1. **ストレージ**タブを選択し、ネームスペースのストレージ使用量を確認します。
1. プロジェクトのストレージ使用量を表示するには、下部のテーブルでプロジェクトを選択します。ストレージ使用量は90分ごとに更新されます。

ネームスペースに`'Not applicable.'`が表示される場合は、ネームスペース内の任意のプロジェクトにコミットをプッシュして、ストレージを再計算します。

ストレージとネットワークの使用量は、バイナリ測定システム（1024ユニットの倍数）で計算されます。ストレージ使用量は、キビバイト（KiB）、メビバイト（MiB）、ギビバイト（GiB）で表示されます。1 KiBは2<sup>10</sup>バイト（1024バイト）、1 MiBは2<sup>20</sup>バイト（1024キビバイト）、1 GiBは2<sup>30</sup>バイト（1024メビバイト）です。

## プロジェクトフォークのストレージ使用量を表示する {#view-project-fork-storage-usage}

プロジェクトフォークによって消費されるストレージにコストファクターが適用されるため、フォークが実際のサイズよりも少なくネームスペースストレージを消費するようになります。フォークストレージ削減のコストファクターは、ネームスペースストレージにのみ適用されます。コストファクターは、プロジェクトリポジトリのストレージ制限には適用されません。

フォークが使用したネームスペースストレージの量を表示するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. **設定 > 使用量クォータ**を選択します。
1. **ストレージ**タブを選択します。**合計**列には、フォークがディスク上の実際のフォークサイズの割り当てとして使用するネームスペースストレージの量が表示されます。

コストファクターは、プロジェクトリポジトリ、LFSオブジェクト、ジョブアーティファクト、パッケージ、スニペット、Wikiに適用されます。

コストファクターは、Freeプランのネームスペースのプライベートフォークには適用されません。

## 超過ストレージ使用量 {#excess-storage-usage}

{{< details >}}

- プラン: Free

{{< /details >}}

超過ストレージ使用量とは、プロジェクトのリポジトリとLFSの10 GiBの無料ストレージを超える量のことです。購入したストレージが利用できない場合、プロジェクトは読み取り専用状態に設定されます。読み取り専用プロジェクトに変更をプッシュすることはできません。

読み取り専用状態を削除するには、ネームスペースのストレージを追加購入する必要があります。購入が完了すると、読み取り専用状態が削除され、プロジェクトが自動的に復元されます。利用可能な購入済みストレージの量は、常にゼロより大きくなければなりません。

**使用量クォータ**ページの**ストレージ**タブには、次のことが示されます。

- 利用可能な購入済みストレージの残量が少なくなっている。
- 利用可能な購入済みストレージがゼロの場合、読み取り専用になるリスクがあるプロジェクト。
- 利用可能な購入済みストレージがゼロであるため、読み取り専用になっているプロジェクト。読み取り専用プロジェクトは、名前の横に情報アイコン（{{< icon name="information-o" >}}）が表示される。

合計ストレージには、無料ストレージと購入済みの超過ストレージが含まれます。残っている超過ストレージはパーセントで表示され、次のように計算されます。100％ - ((超過ストレージ使用量 - 購入済みの超過ストレージ) * 100)％。

### 超過ストレージの例 {#excess-storage-example}

次の例では、ネームスペース内のプロジェクトの超過ストレージのシナリオを示しています。

| リポジトリ | ストレージ使用量 | 超過ストレージ | クォータ  | 状態               |
|------------|--------------|----------------|--------|----------------------|
| 赤        | 10 GiB        | 0 GiB           | 10 GiB  | 読み取り専用{{< icon name="lock" >}} |
| 青       | 8 GiB         | 0 GiB           | 10 GiB  | 読み取り専用ではない        |
| 緑      | 10 GiB        | 0 GiB           | 10 GiB  | 読み取り専用{{< icon name="lock" >}} |
| 黄     | 2 GiB         | 0 GiB           | 10 GiB  | 読み取り専用ではない        |
| **合計** | **30 GiB**    | **0 GiB**       | -      | -                    |

赤と緑のプロジェクトは、リポジトリとLFSが割り当てに達しているため、読み取り専用になっています。この例では、追加のストレージはまだ購入されていません。

赤と緑のプロジェクトから読み取り専用状態を削除するには、50 GiBの追加ストレージを購入します。

一部のプロジェクトのリポジトリとLFSが10 GiBのクォータを超えると、利用可能な購入済みストレージが減少します。

| リポジトリ | ストレージ使用量 | 超過ストレージ | クォータ   | 状態            |
|------------|--------------|----------------|---------|-------------------|
| 赤        | 15 GiB        | 5 GiB         | 10 GiB  | 読み取り専用ではない     |
| 青       | 14 GiB        | 4 GiB         | 10 GiB  | 読み取り専用ではない     |
| 緑      | 11 GiB        | 1 GiB         | 10 GiB  | 読み取り専用ではない     |
| 黄     | 5 GiB         | 0 GiB         | 10 GiB  | 読み取り専用ではない     |
| **合計** | **45 GiB**    | **10 GiB**    | -       | -                 |

この例では、次のようになっています。

- 利用可能な購入済みストレージは40 GiBです。つまり、50 GiB（購入済みストレージ）- 10 GiB（使用された合計超過ストレージ）です。その結果、プロジェクトは読み取り専用ではなくなりました。
- 超過ストレージ使用量は20％です（10 GiB / 50 GiB × 100％）。
- 残りの購入済みストレージは80％です。

## ストレージ使用量を管理する {#manage-storage-usage}

ストレージを管理するために、Free GitLab.comネームスペースのオーナーは、ネームスペースのストレージを追加購入することができます。

PremiumプランとUltimateプランでは、ロール次第ですが、[リポジトリサイズを削減](project/repository/repository_size.md#methods-to-reduce-repository-size)することもできます。ストレージ使用量の分析と管理を自動化するには、[ストレージ管理の自動化](storage_management_automation.md)を参照してください。

ストレージ使用量の管理に加えて、使用可能なストレージを増やすために、次のオプションを検討することができます。

- 対象となる場合は、次の[コミュニティプログラムサブスクリプション](../subscriptions/community_programs.md)に申し込む。
  - 教育団体向けGitLab
  - オープンソース団体向けGitLab
  - スタートアップ向けGitLab
- ストレージ制限のない[GitLab Self-Managedサブスクリプション](../subscriptions/self_managed/_index.md)を検討する。
- オプションの詳細について、[エキスパートに相談する](https://page.gitlab.com/usage_limits_help.html)。

## ストレージをさらに購入する {#purchase-more-storage}

{{< details >}}

- プラン: Free

{{< /details >}}

{{< alert type="note" >}}

Free GitLab.comネームスペースのFreeプランの10 GiB制限を超える場合は、個人またはグループのネームスペースのストレージをさらに購入できます。

{{< /alert >}}

前提要件:

- オーナーロールを持っているか、課金アカウントマネージャーである必要があります。
- 課金アカウントは、個人またはグループのネームスペースのサブスクリプションにリンクされている必要があります。

{{< alert type="note" >}}

ストレージサブスクリプションは、**自動的に毎年更新**されます。[サブスクリプションの自動更新を無効にする](../subscriptions/manage_subscription.md#turn-on-or-turn-off-automatic-subscription-renewal)ことができます。

{{< /alert >}}

### 個人のネームスペースの場合 {#for-your-personal-namespace}

1. GitLab.comにサインインします。
1. 個人のホームページまたはグループのページから、**設定 > 使用量クォータ**に移動します。
1. **ストレージ**タブを選択します。
1. 読み取り専用プロジェクトごとに、プロジェクトの**使用量**が無料のクォータおよび購入済みのストレージをどれだけ超えているかを合計します。この合計を超えるストレージ増分を購入する必要があります。
1. **ストレージを購入**を選択します。カスタマーポータルに移動します。
1. **サブスクリプションの詳細**セクションで、ドロップダウンリストからユーザーの名前を選択します。
1. 必要なストレージパックの数量を入力します。
1. **顧客情報**セクションで、住所を確認します。
1. **料金情報**セクションで、ドロップダウンリストから支払い方法を選択します。
1. **プライバシーに関する声明**チェックボックスと**利用規約**チェックボックスをオンにします。
1. **ストレージを購入**を選択します。

**購入した利用可能なストレージ**の合計が、購入した分だけ増えます。すべてのプロジェクトの読み取り専用状態が削除され、超過使用量が追加ストレージから差し引かれます。

### グループのネームスペースの場合 {#for-your-group-namespace}

GitLab.comを使用している場合、追加のストレージを購入して、メインのクォータからすべてのストレージを使い果たしたときにパイプラインがブロックされないようにします。追加ストレージの価格は、[GitLabの価格ページ](https://about.gitlab.com/pricing/#storage)に記載されています。

GitLab.comでグループの追加ストレージを購入するには、次の手順に従います。

{{< tabs >}}

{{< tab title="グループオーナー" >}}

1. GitLab.comにサインインします。
1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **設定 > 使用量クォータ**を選択します。
1. **ストレージ**タブを選択します。
1. **ストレージを購入**を選択します。カスタマーポータルに移動します。
1. **サブスクリプションの詳細**セクションの**数量**フィールドに、必要なストレージパックの数量を入力します。
1. **顧客情報**セクションで、住所を確認します。
1. **料金情報**セクションで、ドロップダウンリストから支払い方法を選択します。
1. **プライバシーに関する声明**チェックボックスと**利用規約**チェックボックスをオンにします。
1. **ストレージを購入**を選択します。

{{< /tab >}}

{{< tab title="課金アカウントマネージャー" >}}

1. [カスタマーポータル](https://customers.gitlab.com/customers/sign_in)に移動します。
1. サブスクリプションカードで、縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、**ストレージの追加購入**を選択します。
1. **サブスクリプションの詳細**セクションの**数量**フィールドに、必要なストレージパックの数量を入力します。
1. **顧客情報**セクションで、住所を確認します。
1. **料金情報**セクションで、ドロップダウンリストから支払い方法を選択します。
1. **プライバシーに関する声明**チェックボックスと**利用規約**チェックボックスをオンにします。
1. **ストレージを購入**を選択します。

{{< /tab >}}

{{< /tabs >}}

支払いが処理されると、グループのネームスペースで追加のストレージを使用できるようになります。

利用可能なストレージを確認するには、前述の最初の3つの手順を実行します。

**購入した利用可能なストレージ**の合計が、購入した分だけ増えます。ロックされているすべてのプロジェクトのロックが解除され、超過使用量は追加ストレージから差し引かれます。

## プロジェクトの固定制限 {#fixed-project-limit}

{{< details >}}

- プラン: Premium、Ultimate

{{< /details >}}

プロジェクトのリポジトリとLFSが500 GiBを超えると、プロジェクトは読み取り専用状態になります。この場合、グループとトップレベルネームスペースのオーナーは、ストレージ使用量を管理するように警告するアプリ内通知とメール通知を受け取ります。アカウントチームとサポートチームと協力して、使用量を管理できます。500 GiBのプロジェクトの固定制限は、プラットフォーム全体の安定性を確保するために設けられています。

{{< alert type="note" >}}

これらの制限はプロジェクトごとに固定されています。ストレージを追加購入しても、単一プロジェクトの最大制限が増加するわけではありません。利用可能なストレージ全体の拡張のみが行われます。たとえば、1 TBのストレージを購入しても、1つのプロジェクトが500 GiBの上限を超えることはありません。

{{< /alert >}}

## 期限切れのストレージ {#expired-storage}

ストレージがサブスクリプション期間の終了時に誤ってプロビジョニング解除されない場合、期限切れのストレージがサブスクリプションに存在するようになります。購入済みストレージが予想外に減少した場合は、期限切れのストレージがアカウントから削除された可能性があります。詳細とソリューションについては、サポートにお問い合わせください。
