/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.unix;

import ghidra.pty.unix.PosixC;
import java.util.List;

public abstract class UnixPtySessionLeader {
    private static final PosixC LIB_POSIX = PosixC.INSTANCE;
    private static final int O_RDWR = 2;
    protected String ptyPath;
    protected List<String> subArgs;

    protected abstract PosixC.Ioctls ioctls();

    protected void parseArgs(String[] args) {
        this.ptyPath = args[0];
        this.subArgs = List.of(args).subList(1, args.length);
    }

    protected void run() throws Exception {
        int bk = -1;
        try {
            int fd = LIB_POSIX.open(this.ptyPath, 2, 0);
            int bkt = fd + 1;
            LIB_POSIX.dup2(2, bkt);
            bk = bkt;
            LIB_POSIX.close(0);
            LIB_POSIX.close(1);
            LIB_POSIX.close(2);
            LIB_POSIX.dup2(fd, 0);
            LIB_POSIX.dup2(fd, 1);
            LIB_POSIX.dup2(fd, 2);
            LIB_POSIX.close(fd);
            LIB_POSIX.setsid();
            PosixC.ControllingTty.ByReference ctty = new PosixC.ControllingTty.ByReference();
            ctty.steal = 0;
            LIB_POSIX.ioctl(0, this.ioctls().TIOCSCTTY(), ctty.getPointer());
            LIB_POSIX.execv(this.subArgs.get(0), this.subArgs.toArray(new String[0]));
        }
        catch (Throwable t) {
            System.err.println("Could not execute " + this.subArgs.get(0) + ": " + t.getMessage());
            if (bk != -1) {
                try {
                    int bkt = bk;
                    LIB_POSIX.dup2(bkt, 2);
                }
                catch (Throwable t2) {
                    System.exit(-1);
                }
            }
            System.err.println("Could not execute " + this.subArgs.get(0) + ": " + t.getMessage());
            System.exit(127);
        }
    }
}

